/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.content;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.syncope.core.persistence.api.content.ContentLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.xml.sax.SAXException;

public abstract class AbstractXMLContentLoader
implements ContentLoader {
    protected static final Logger LOG = LoggerFactory.getLogger(ContentLoader.class);
    protected final Environment env;

    protected AbstractXMLContentLoader(Environment env) {
        this.env = env;
    }

    public int getOrder() {
        return 400;
    }

    protected abstract boolean existingData(String var1);

    protected abstract void createViews(String var1) throws IOException;

    protected abstract void createIndexes(String var1) throws IOException;

    protected SAXParser saxParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return factory.newSAXParser();
    }

    protected abstract void loadDefaultContent(String var1, String var2) throws Exception;

    public void load(String domain) {
        LOG.debug("Loading data for domain [{}]", (Object)domain);
        if (this.existingData(domain)) {
            LOG.info("[{}] Data found in the database, leaving untouched", (Object)domain);
        } else {
            LOG.info("[{}] Empty database found, loading default content", (Object)domain);
            try {
                this.createViews(domain);
            }
            catch (IOException e) {
                LOG.error("[{}] While creating views", (Object)domain, (Object)e);
            }
            try {
                this.createIndexes(domain);
            }
            catch (IOException e) {
                LOG.error("[{}] While creating indexes", (Object)domain, (Object)e);
            }
            try {
                this.loadDefaultContent(domain, domain + "ContentXML");
            }
            catch (Exception e) {
                LOG.error("[{}] While loading default content", (Object)domain, (Object)e);
            }
        }
    }
}

