/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;

public class QuorumConfig {
    private static final String QUORUM_PREFIX = "controller.quorum.";
    public static final String NON_ROUTABLE_HOST = "0.0.0.0";
    public static final String QUORUM_VOTERS_CONFIG = "controller.quorum.voters";
    public static final String QUORUM_VOTERS_DOC = "Map of id/endpoint information for the set of voters in a comma-separated list of <code>{id}@{host}:{port}</code> entries. For example: <code>1@localhost:9092,2@localhost:9093,3@localhost:9094</code>";
    public static final List<String> DEFAULT_QUORUM_VOTERS = Collections.emptyList();
    public static final String QUORUM_BOOTSTRAP_SERVERS_CONFIG = "controller.quorum.bootstrap.servers";
    public static final String QUORUM_BOOTSTRAP_SERVERS_DOC = "List of endpoints to use for bootstrapping the cluster metadata. The endpoints are specified in comma-separated list of <code>{host}:{port}</code> entries. For example: <code>localhost:9092,localhost:9093,localhost:9094</code>.";
    public static final List<String> DEFAULT_QUORUM_BOOTSTRAP_SERVERS = Collections.emptyList();
    public static final String QUORUM_ELECTION_TIMEOUT_MS_CONFIG = "controller.quorum.election.timeout.ms";
    public static final String QUORUM_ELECTION_TIMEOUT_MS_DOC = "Maximum time in milliseconds to wait without being able to fetch from the leader before triggering a new election";
    public static final int DEFAULT_QUORUM_ELECTION_TIMEOUT_MS = 1000;
    public static final String QUORUM_FETCH_TIMEOUT_MS_CONFIG = "controller.quorum.fetch.timeout.ms";
    public static final String QUORUM_FETCH_TIMEOUT_MS_DOC = "Maximum time without a successful fetch from the current leader before becoming a candidate and triggering an election for voters; Maximum time a leader can go without receiving valid fetch or fetchSnapshot request from a majority of the quorum before resigning.";
    public static final int DEFAULT_QUORUM_FETCH_TIMEOUT_MS = 2000;
    public static final String QUORUM_ELECTION_BACKOFF_MAX_MS_CONFIG = "controller.quorum.election.backoff.max.ms";
    public static final String QUORUM_ELECTION_BACKOFF_MAX_MS_DOC = "Maximum time in milliseconds before starting new elections. This is used in the binary exponential backoff mechanism that helps prevent gridlocked elections";
    public static final int DEFAULT_QUORUM_ELECTION_BACKOFF_MAX_MS = 1000;
    public static final String QUORUM_LINGER_MS_CONFIG = "controller.quorum.append.linger.ms";
    public static final String QUORUM_LINGER_MS_DOC = "The duration in milliseconds that the leader will wait for writes to accumulate before flushing them to disk.";
    public static final int DEFAULT_QUORUM_LINGER_MS = 25;
    public static final String QUORUM_REQUEST_TIMEOUT_MS_CONFIG = "controller.quorum.request.timeout.ms";
    public static final String QUORUM_REQUEST_TIMEOUT_MS_DOC = "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.";
    public static final int DEFAULT_QUORUM_REQUEST_TIMEOUT_MS = 2000;
    public static final String QUORUM_RETRY_BACKOFF_MS_CONFIG = "controller.quorum.retry.backoff.ms";
    public static final String QUORUM_RETRY_BACKOFF_MS_DOC = "The amount of time to wait before attempting to retry a failed request to a given topic partition. This avoids repeatedly sending requests in a tight loop under some failure scenarios. This value is the initial backoff value and will increase exponentially for each failed request, up to the <code>retry.backoff.max.ms</code> value.";
    public static final int DEFAULT_QUORUM_RETRY_BACKOFF_MS = 20;
    private final int requestTimeoutMs;
    private final int retryBackoffMs;
    private final int electionTimeoutMs;
    private final int electionBackoffMaxMs;
    private final int fetchTimeoutMs;
    private final int appendLingerMs;

    public QuorumConfig(AbstractConfig abstractConfig) {
        this(abstractConfig.getInt(QUORUM_REQUEST_TIMEOUT_MS_CONFIG), abstractConfig.getInt(QUORUM_RETRY_BACKOFF_MS_CONFIG), abstractConfig.getInt(QUORUM_ELECTION_TIMEOUT_MS_CONFIG), abstractConfig.getInt(QUORUM_ELECTION_BACKOFF_MAX_MS_CONFIG), abstractConfig.getInt(QUORUM_FETCH_TIMEOUT_MS_CONFIG), abstractConfig.getInt(QUORUM_LINGER_MS_CONFIG));
    }

    public QuorumConfig(int requestTimeoutMs, int retryBackoffMs, int electionTimeoutMs, int electionBackoffMaxMs, int fetchTimeoutMs, int appendLingerMs) {
        this.requestTimeoutMs = requestTimeoutMs;
        this.retryBackoffMs = retryBackoffMs;
        this.electionTimeoutMs = electionTimeoutMs;
        this.electionBackoffMaxMs = electionBackoffMaxMs;
        this.fetchTimeoutMs = fetchTimeoutMs;
        this.appendLingerMs = appendLingerMs;
    }

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public int retryBackoffMs() {
        return this.retryBackoffMs;
    }

    public int electionTimeoutMs() {
        return this.electionTimeoutMs;
    }

    public int electionBackoffMaxMs() {
        return this.electionBackoffMaxMs;
    }

    public int fetchTimeoutMs() {
        return this.fetchTimeoutMs;
    }

    public int appendLingerMs() {
        return this.appendLingerMs;
    }

    private static Integer parseVoterId(String idString) {
        try {
            return Integer.parseInt(idString);
        }
        catch (NumberFormatException e) {
            throw new ConfigException("Failed to parse voter ID as an integer from " + idString);
        }
    }

    public static Map<Integer, InetSocketAddress> parseVoterConnections(List<String> voterEntries) {
        return QuorumConfig.parseVoterConnections(voterEntries, true);
    }

    public static Set<Integer> parseVoterIds(List<String> voterEntries) {
        return QuorumConfig.parseVoterConnections(voterEntries, false).keySet();
    }

    private static Map<Integer, InetSocketAddress> parseVoterConnections(List<String> voterEntries, boolean requireRoutableAddresses) {
        HashMap<Integer, InetSocketAddress> voterMap = new HashMap<Integer, InetSocketAddress>(voterEntries.size());
        for (String voterMapEntry : voterEntries) {
            String[] idAndAddress = voterMapEntry.split("@");
            if (idAndAddress.length != 2) {
                throw new ConfigException("Invalid configuration value for controller.quorum.voters. Each entry should be in the form `{id}@{host}:{port}`.");
            }
            Integer voterId = QuorumConfig.parseVoterId(idAndAddress[0]);
            String host = Utils.getHost((String)idAndAddress[1]);
            if (host == null || !Utils.validHostPattern((String)host)) {
                throw new ConfigException("Failed to parse host name from entry " + voterMapEntry + " for the configuration " + QUORUM_VOTERS_CONFIG + ". Each entry should be in the form `{id}@{host}:{port}`.");
            }
            Integer port = Utils.getPort((String)idAndAddress[1]);
            if (port == null) {
                throw new ConfigException("Failed to parse host port from entry " + voterMapEntry + " for the configuration " + QUORUM_VOTERS_CONFIG + ". Each entry should be in the form `{id}@{host}:{port}`.");
            }
            InetSocketAddress address = new InetSocketAddress(host, (int)port);
            if (address.getHostString().equals(NON_ROUTABLE_HOST) && requireRoutableAddresses) {
                throw new ConfigException(String.format("Host string (%s) is not routeable", address.getHostString()));
            }
            voterMap.put(voterId, address);
        }
        return voterMap;
    }

    public static List<InetSocketAddress> parseBootstrapServers(List<String> bootstrapServers) {
        return bootstrapServers.stream().map(QuorumConfig::parseBootstrapServer).collect(Collectors.toList());
    }

    private static InetSocketAddress parseBootstrapServer(String bootstrapServer) {
        String host = Utils.getHost((String)bootstrapServer);
        if (host == null || !Utils.validHostPattern((String)host)) {
            throw new ConfigException(String.format("Failed to parse host name from {} for the configuration {}. Each entry should be in the form \"{host}:{port}\"", bootstrapServer, QUORUM_BOOTSTRAP_SERVERS_CONFIG));
        }
        Integer port = Utils.getPort((String)bootstrapServer);
        if (port == null) {
            throw new ConfigException(String.format("Failed to parse host port from {} for the configuration {}. Each entry should be in the form \"{host}:{port}\"", bootstrapServer, QUORUM_BOOTSTRAP_SERVERS_CONFIG));
        }
        return InetSocketAddress.createUnresolved(host, port);
    }

    public static List<Node> quorumVoterStringsToNodes(List<String> voters) {
        return QuorumConfig.voterConnectionsToNodes(QuorumConfig.parseVoterConnections(voters));
    }

    public static List<Node> voterConnectionsToNodes(Map<Integer, InetSocketAddress> voterConnections) {
        return voterConnections.entrySet().stream().filter(Objects::nonNull).map(entry -> new Node(((Integer)entry.getKey()).intValue(), ((InetSocketAddress)entry.getValue()).getHostString(), ((InetSocketAddress)entry.getValue()).getPort())).collect(Collectors.toList());
    }

    public static class ControllerQuorumBootstrapServersValidator
    implements ConfigDef.Validator {
        public void ensureValid(String name, Object value) {
            if (value == null) {
                throw new ConfigException(name, null);
            }
            List entries = (List)value;
            for (String entry : entries) {
                QuorumConfig.parseBootstrapServer(entry);
            }
        }

        public String toString() {
            return "non-empty list";
        }
    }

    public static class ControllerQuorumVotersValidator
    implements ConfigDef.Validator {
        public void ensureValid(String name, Object value) {
            if (value == null) {
                throw new ConfigException(name, null);
            }
            List voterStrings = (List)value;
            QuorumConfig.parseVoterConnections(voterStrings, false);
        }

        public String toString() {
            return "non-empty list";
        }
    }
}

