/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.config.builder.AbstractBuilder;
import org.pac4j.config.builder.CasClientBuilder;
import org.pac4j.config.builder.DbAuthenticatorBuilder;
import org.pac4j.config.builder.DirectClientBuilder;
import org.pac4j.config.builder.IndirectHttpClientBuilder;
import org.pac4j.config.builder.LdapAuthenticatorBuilder;
import org.pac4j.config.builder.OAuthBuilder;
import org.pac4j.config.builder.OidcClientBuilder;
import org.pac4j.config.builder.RestAuthenticatorBuilder;
import org.pac4j.config.builder.Saml2ClientBuilder;
import org.pac4j.config.builder.ShiroEncoderBuilder;
import org.pac4j.config.builder.SpringEncoderBuilder;
import org.pac4j.core.client.Client;
import org.pac4j.core.config.Config;
import org.pac4j.core.config.ConfigFactory;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.password.PasswordEncoder;

public class PropertiesConfigFactory
extends AbstractBuilder
implements ConfigFactory {
    private final String callbackUrl;

    public PropertiesConfigFactory(Map<String, String> properties) {
        this((String)null, properties);
    }

    public PropertiesConfigFactory(String callbackUrl, Map<String, String> properties) {
        super(properties);
        this.callbackUrl = callbackUrl;
    }

    public Config build(Object ... parameters) {
        ArrayList<Client> clients = new ArrayList<Client>();
        HashMap<String, Authenticator> authenticators = new HashMap<String, Authenticator>();
        HashMap<String, PasswordEncoder> encoders = new HashMap<String, PasswordEncoder>();
        if (this.hasSpringEncoder()) {
            SpringEncoderBuilder springEncoderBuilder = new SpringEncoderBuilder(this.properties);
            springEncoderBuilder.tryCreatePasswordEncoder(encoders);
        }
        if (this.hasShiroEncoder()) {
            ShiroEncoderBuilder shiroEncoderBuilder = new ShiroEncoderBuilder(this.properties);
            shiroEncoderBuilder.tryCreatePasswordEncoder(encoders);
        }
        if (this.hasLdapAuthenticator()) {
            LdapAuthenticatorBuilder ldapAuthenticatorBuilder = new LdapAuthenticatorBuilder(this.properties);
            ldapAuthenticatorBuilder.tryBuildLdapAuthenticator(authenticators);
        }
        if (this.hasDbAuthenticator()) {
            DbAuthenticatorBuilder dbAuthenticatorBuilder = new DbAuthenticatorBuilder(this.properties);
            dbAuthenticatorBuilder.tryBuildDbAuthenticator(authenticators, encoders);
        }
        if (this.hasOAuthClients()) {
            OAuthBuilder oAuthBuilder = new OAuthBuilder(this.properties);
            oAuthBuilder.tryCreateFacebookClient(clients);
            oAuthBuilder.tryCreateTwitterClient(clients);
            oAuthBuilder.tryCreateDropboxClient(clients);
            oAuthBuilder.tryCreateGithubClient(clients);
            oAuthBuilder.tryCreateYahooClient(clients);
            oAuthBuilder.tryCreateGoogleClient(clients);
            oAuthBuilder.tryCreateFoursquareClient(clients);
            oAuthBuilder.tryCreateWindowsLiveClient(clients);
            oAuthBuilder.tryCreateLinkedInClient(clients);
            oAuthBuilder.tryCreateGenericOAuth2Clients(clients);
        }
        if (this.hasSaml2Clients()) {
            Saml2ClientBuilder saml2ClientBuilder = new Saml2ClientBuilder(this.properties);
            saml2ClientBuilder.tryCreateSaml2Client(clients);
        }
        if (this.hasCasClients()) {
            CasClientBuilder casClientBuilder = new CasClientBuilder(this.properties);
            casClientBuilder.tryCreateCasClient(clients);
        }
        if (this.hasOidcClients()) {
            OidcClientBuilder oidcClientBuilder = new OidcClientBuilder(this.properties);
            oidcClientBuilder.tryCreateOidcClient(clients);
        }
        if (this.hasHttpAuthenticatorsOrClients()) {
            RestAuthenticatorBuilder restAuthenticatorBuilder = new RestAuthenticatorBuilder(this.properties);
            restAuthenticatorBuilder.tryBuildRestAuthenticator(authenticators);
            IndirectHttpClientBuilder indirectHttpClientBuilder = new IndirectHttpClientBuilder(this.properties, authenticators);
            indirectHttpClientBuilder.tryCreateLoginFormClient(clients);
            indirectHttpClientBuilder.tryCreateIndirectBasicAuthClient(clients);
            DirectClientBuilder directClientBuilder = new DirectClientBuilder(this.properties, authenticators);
            directClientBuilder.tryCreateAnonymousClient(clients);
            directClientBuilder.tryCreateDirectBasciAuthClient(clients);
        }
        return new Config(this.callbackUrl, clients);
    }

    protected boolean hasShiroEncoder() {
        for (int i = 0; i <= 10; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)this.getProperty("encoder.shiro", i)) && !this.containsProperty("encoder.shiro.generatePublicSalt", i) && !this.containsProperty("encoder.shiro.hashAlgorithmName", i) && !this.containsProperty("encoder.shiro.hashIterations", i) && !this.containsProperty("encoder.shiro.privateSalt", i)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSpringEncoder() {
        for (int i = 0; i <= 10; ++i) {
            String type = this.getProperty("encoder.spring.type", i);
            if (!StringUtils.isNotBlank((CharSequence)type)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasLdapAuthenticator() {
        for (int i = 0; i <= 10; ++i) {
            String type = this.getProperty("ldap.type", i);
            if (!StringUtils.isNotBlank((CharSequence)type)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasDbAuthenticator() {
        for (int i = 0; i <= 10; ++i) {
            String className = this.getProperty("db.dataSourceClassName", i);
            String jdbcUrl = this.getProperty("db.jdbcUrl", i);
            if (!StringUtils.isNotBlank((CharSequence)className) && !StringUtils.isNotBlank((CharSequence)jdbcUrl)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasOAuthClients() {
        if (StringUtils.isNotBlank((CharSequence)this.getProperty("linkedin.id")) && StringUtils.isNotBlank((CharSequence)this.getProperty("linkedin.secret"))) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getProperty("facebook.id")) && StringUtils.isNotBlank((CharSequence)this.getProperty("facebook.secret"))) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getProperty("windowslive.id")) && StringUtils.isNotBlank((CharSequence)this.getProperty("windowslive.secret"))) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getProperty("foursquare.id")) && StringUtils.isNotBlank((CharSequence)this.getProperty("foursquare.secret"))) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getProperty("google.id")) && StringUtils.isNotBlank((CharSequence)this.getProperty("google.secret"))) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getProperty("yahoo.id")) && StringUtils.isNotBlank((CharSequence)this.getProperty("yahoo.secret"))) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getProperty("dropbox.id")) && StringUtils.isNotBlank((CharSequence)this.getProperty("dropbox.secret"))) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getProperty("github.id")) && StringUtils.isNotBlank((CharSequence)this.getProperty("github.secret"))) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getProperty("twitter.id")) && StringUtils.isNotBlank((CharSequence)this.getProperty("twitter.secret"))) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)this.getProperty("oauth2.id")) && StringUtils.isNotBlank((CharSequence)this.getProperty("oauth2.secret")) && StringUtils.isNotBlank((CharSequence)this.getProperty("oauth2.authUrl")) && StringUtils.isNotBlank((CharSequence)this.getProperty("oauth2.tokenUrl"));
    }

    protected boolean hasSaml2Clients() {
        for (int i = 0; i <= 100; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)this.getProperty("saml.keystorePassword", i)) || !StringUtils.isNotBlank((CharSequence)this.getProperty("saml.privateKeyPassword", i)) || !StringUtils.isNotBlank((CharSequence)this.getProperty("saml.keystorePath", i)) || !StringUtils.isNotBlank((CharSequence)this.getProperty("saml.identityProviderMetadataPath", i))) continue;
            return true;
        }
        return false;
    }

    protected boolean hasCasClients() {
        for (int i = 0; i <= 100; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)this.getProperty("cas.loginUrl", i))) continue;
            return true;
        }
        return false;
    }

    protected boolean hasOidcClients() {
        for (int i = 0; i <= 100; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)this.getProperty("oidc.id", i)) || !StringUtils.isNotBlank((CharSequence)this.getProperty("oidc.secret", i))) continue;
            return true;
        }
        return false;
    }

    protected boolean hasHttpAuthenticatorsOrClients() {
        int i;
        if (StringUtils.isNotBlank((CharSequence)this.getProperty("anonymous"))) {
            return true;
        }
        for (i = 0; i <= 10; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)this.getProperty("rest.url", i))) continue;
            return true;
        }
        for (i = 0; i <= 100; ++i) {
            if (StringUtils.isNotBlank((CharSequence)this.getProperty("formClient.loginUrl", i)) && StringUtils.isNotBlank((CharSequence)this.getProperty("formClient.authenticator", i))) {
                return true;
            }
            if (StringUtils.isNotBlank((CharSequence)this.getProperty("indirectBasicAuth.authenticator", i))) {
                return true;
            }
            if (!StringUtils.isNotBlank((CharSequence)this.getProperty("directBasicAuth.authenticator", i))) continue;
            return true;
        }
        return false;
    }
}

