/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.surrogate;

import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.surrogate.BaseSurrogateAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredServicePrincipalAccessStrategyEnforcer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;

public class GroovySurrogateAuthenticationService
extends BaseSurrogateAuthenticationService
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovySurrogateAuthenticationService.class);
    private final ExecutableCompiledScript watchableScript;

    public GroovySurrogateAuthenticationService(ServicesManager servicesManager, CasConfigurationProperties casProperties, RegisteredServicePrincipalAccessStrategyEnforcer principalAccessStrategyEnforcer, ConfigurableApplicationContext applicationContext) {
        super(servicesManager, casProperties, principalAccessStrategyEnforcer, applicationContext);
        ExecutableCompiledScriptFactory scriptFactory = ExecutableCompiledScriptFactory.getExecutableCompiledScriptFactory();
        Resource groovyResource = casProperties.getAuthn().getSurrogate().getGroovy().getLocation();
        this.watchableScript = scriptFactory.fromResource(groovyResource);
    }

    @Override
    public boolean canImpersonateInternal(String surrogate, Principal principal, Optional<? extends Service> service) throws Throwable {
        Object[] args = new Object[]{surrogate, principal, service.orElse(null), LOGGER};
        return (Boolean)this.watchableScript.execute("canAuthenticate", Boolean.class, args);
    }

    public Collection<String> getImpersonationAccounts(String username, Optional<? extends Service> service) throws Throwable {
        Object[] args = new Object[]{username, service.orElse(null), LOGGER};
        return (Collection)this.watchableScript.execute("getAccounts", Collection.class, args);
    }

    public boolean isWildcardedAccount(String surrogate, Principal principal, Optional<? extends Service> service) throws Throwable {
        Object[] args = new Object[]{surrogate, principal, service.orElse(null), LOGGER};
        return super.isWildcardedAccount(surrogate, principal, service) && (Boolean)this.watchableScript.execute("isWildcardAuthorized", Boolean.class, args) != false;
    }

    public void destroy() {
        this.watchableScript.close();
    }
}

