/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Comparator;
import java.util.List;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.support.geo.GeoLocationServiceConfigurer;
import org.apereo.cas.support.geo.GroovyGeoLocationService;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.spring.boot.ConditionalOnMissingGraalVMNativeImage;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.GeoLocation})
@AutoConfiguration
public class CasGeoLocationAutoConfiguration {
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public GeoLocationService geoLocationService(List<GeoLocationServiceConfigurer> providers) {
        List<GeoLocationService> services = providers.stream().map(GeoLocationServiceConfigurer::configure).filter(BeanSupplier::isNotProxy).sorted((Comparator<GeoLocationService>)AnnotationAwareOrderComparator.INSTANCE).toList();
        return (GeoLocationService)BeanSupplier.of(GeoLocationService.class).when(!services.isEmpty()).supply(services::getFirst).otherwiseProxy().get();
    }

    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @Configuration(value="GroovyGeoLocationConfiguration", proxyBeanMethods=false)
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.GeoLocation})
    static class GroovyGeoLocationConfiguration {
        GroovyGeoLocationConfiguration() {
        }

        @ConditionalOnMissingBean(name={"groovyGeoLocationService"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingGraalVMNativeImage
        public GeoLocationService groovyGeoLocationService(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (GeoLocationService)BeanSupplier.of(GeoLocationService.class).when(BeanCondition.on((String)"cas.geo-location.groovy.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                ExecutableCompiledScriptFactory scriptFactory = ExecutableCompiledScriptFactory.getExecutableCompiledScriptFactory();
                ExecutableCompiledScript resource = scriptFactory.fromResource(casProperties.getGeoLocation().getGroovy().getLocation());
                return new GroovyGeoLocationService(resource, (ApplicationContext)applicationContext);
            }).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"groovyGeoLocationServiceConfigurer"})
        @ConditionalOnMissingGraalVMNativeImage
        public GeoLocationServiceConfigurer groovyGeoLocationServiceConfigurer(@Qualifier(value="groovyGeoLocationService") GeoLocationService groovyGeoLocationService) {
            return () -> groovyGeoLocationService;
        }
    }
}

