/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.services.LogicalOperatorTypes;
import org.apereo.cas.services.RegisteredServiceAttributeReleaseActivationCriteria;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class AttributeBasedRegisteredServiceAttributeReleaseActivationCriteria
implements RegisteredServiceAttributeReleaseActivationCriteria {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AttributeBasedRegisteredServiceAttributeReleaseActivationCriteria.class);
    private static final long serialVersionUID = 5942510462696845607L;
    @JsonProperty(value="requiredAttributes")
    private Map<String, Object> requiredAttributes = new TreeMap<String, Object>();
    private int order;
    private LogicalOperatorTypes operator = LogicalOperatorTypes.AND;
    private boolean reverseMatch;

    public boolean shouldActivate(RegisteredServiceAttributeReleasePolicyContext context) {
        Stream stream = this.requiredAttributes.entrySet().stream();
        Map attributes = CoreAuthenticationUtils.mergeAttributes(new HashMap(context.getPrincipal().getAttributes()), (Map)context.getReleasingAttributes());
        LOGGER.debug("Activation criteria will examine attributes [{}]", (Object)attributes);
        if (this.reverseMatch) {
            return stream.noneMatch(entry -> this.verifyRequiredAttribute((Map.Entry<String, Object>)entry, attributes));
        }
        return this.operator == LogicalOperatorTypes.AND ? stream.allMatch(entry -> this.verifyRequiredAttribute((Map.Entry<String, Object>)entry, attributes)) : stream.anyMatch(entry -> this.verifyRequiredAttribute((Map.Entry<String, Object>)entry, attributes));
    }

    protected boolean verifyRequiredAttribute(Map.Entry<String, Object> entry, Map<String, List<Object>> attributes) {
        List currentValues = (List)ObjectUtils.defaultIfNull(attributes.get(entry.getKey()), List.of());
        Set requiredValues = CollectionUtils.toCollection((Object)entry.getValue());
        Pattern pattern = RegexUtils.concatenate((Collection)requiredValues, (boolean)true);
        LOGGER.debug("Checking activation criteria [{}] against [{}] with pattern [{}] for attribute [{}]", new Object[]{requiredValues, currentValues, pattern, entry.getKey()});
        return currentValues.stream().map(Object::toString).anyMatch(pattern.asPredicate());
    }

    @Generated
    public Map<String, Object> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public LogicalOperatorTypes getOperator() {
        return this.operator;
    }

    @Generated
    public boolean isReverseMatch() {
        return this.reverseMatch;
    }

    @JsonProperty(value="requiredAttributes")
    @Generated
    public AttributeBasedRegisteredServiceAttributeReleaseActivationCriteria setRequiredAttributes(Map<String, Object> requiredAttributes) {
        this.requiredAttributes = requiredAttributes;
        return this;
    }

    @Generated
    public AttributeBasedRegisteredServiceAttributeReleaseActivationCriteria setOrder(int order) {
        this.order = order;
        return this;
    }

    @Generated
    public AttributeBasedRegisteredServiceAttributeReleaseActivationCriteria setOperator(LogicalOperatorTypes operator) {
        this.operator = operator;
        return this;
    }

    @Generated
    public AttributeBasedRegisteredServiceAttributeReleaseActivationCriteria setReverseMatch(boolean reverseMatch) {
        this.reverseMatch = reverseMatch;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeBasedRegisteredServiceAttributeReleaseActivationCriteria)) {
            return false;
        }
        AttributeBasedRegisteredServiceAttributeReleaseActivationCriteria other = (AttributeBasedRegisteredServiceAttributeReleaseActivationCriteria)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        if (this.reverseMatch != other.reverseMatch) {
            return false;
        }
        Map<String, Object> this$requiredAttributes = this.requiredAttributes;
        Map<String, Object> other$requiredAttributes = other.requiredAttributes;
        if (this$requiredAttributes == null ? other$requiredAttributes != null : !((Object)this$requiredAttributes).equals(other$requiredAttributes)) {
            return false;
        }
        LogicalOperatorTypes this$operator = this.operator;
        LogicalOperatorTypes other$operator = other.operator;
        return !(this$operator == null ? other$operator != null : !this$operator.equals(other$operator));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AttributeBasedRegisteredServiceAttributeReleaseActivationCriteria;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.order;
        result = result * 59 + (this.reverseMatch ? 79 : 97);
        Map<String, Object> $requiredAttributes = this.requiredAttributes;
        result = result * 59 + ($requiredAttributes == null ? 43 : ((Object)$requiredAttributes).hashCode());
        LogicalOperatorTypes $operator = this.operator;
        result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
        return result;
    }

    @Generated
    public AttributeBasedRegisteredServiceAttributeReleaseActivationCriteria() {
    }
}

