/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.transport;

import java.time.Duration;
import java.util.Arrays;
import java.util.function.Predicate;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Message;
import org.ldaptive.Result;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchOperationHandle;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.SearchResultReference;
import org.ldaptive.extended.IntermediateResponse;
import org.ldaptive.handler.CompleteHandler;
import org.ldaptive.handler.ExceptionHandler;
import org.ldaptive.handler.IntermediateResponseHandler;
import org.ldaptive.handler.LdapEntryHandler;
import org.ldaptive.handler.ReferralHandler;
import org.ldaptive.handler.ReferralResultHandler;
import org.ldaptive.handler.ResponseControlHandler;
import org.ldaptive.handler.ResultHandler;
import org.ldaptive.handler.ResultPredicate;
import org.ldaptive.handler.SearchReferenceHandler;
import org.ldaptive.handler.SearchResultHandler;
import org.ldaptive.handler.UnsolicitedNotificationHandler;
import org.ldaptive.referral.FollowSearchReferralHandler;
import org.ldaptive.transport.DefaultOperationHandle;
import org.ldaptive.transport.TransportConnection;

public final class DefaultSearchOperationHandle
extends DefaultOperationHandle<SearchRequest, SearchResponse>
implements SearchOperationHandle {
    private static final Predicate<Message> SEARCH_RESPONSE_TIMEOUT_CONDITION = new Predicate<Message>(){

        @Override
        public boolean test(Message message) {
            return message instanceof IntermediateResponse || message instanceof LdapEntry || message instanceof SearchResultReference || message instanceof SearchResponse;
        }

        public String toString() {
            return "SEARCH_RESPONSE_TIMEOUT_CONDITION";
        }
    };
    private static final boolean SORT_RESULTS = Boolean.parseBoolean(System.getProperty("org.ldaptive.sortSearchResults", "false"));
    private final SearchResponse result = new SearchResponse();
    private int entryCount;
    private LdapEntryHandler[] onEntry;
    private SearchReferenceHandler[] onReference;
    private SearchResultHandler[] onSearchResult;

    public DefaultSearchOperationHandle(SearchRequest req, TransportConnection conn, Duration timeout) {
        super(req, conn, timeout);
    }

    @Override
    protected Predicate<Message> getResponseTimeoutCondition() {
        return SEARCH_RESPONSE_TIMEOUT_CONDITION;
    }

    @Override
    public DefaultSearchOperationHandle send() {
        super.send();
        return this;
    }

    @Override
    public SearchResponse await() throws LdapException {
        SearchResponse done = (SearchResponse)super.await();
        if (this.onSearchResult != null) {
            for (SearchResultHandler func : this.onSearchResult) {
                SearchResponse handlerResponse;
                try {
                    handlerResponse = (SearchResponse)func.apply(done);
                }
                catch (Exception ex) {
                    if (ex.getCause() instanceof LdapException) {
                        throw (LdapException)ex.getCause();
                    }
                    throw new LdapException("Search result handler " + func + " threw exception", (Throwable)ex);
                }
                if (handlerResponse == null) {
                    throw new LdapException("Search result handler " + func + " returned null result");
                }
                if (!(handlerResponse.equalsResult(done) || ResultCode.REFERRAL == done.getResultCode() && FollowSearchReferralHandler.class.equals(func.getClass()))) {
                    throw new LdapException("Cannot modify search result instance with handler " + func);
                }
                done = handlerResponse;
            }
        }
        super.evaluateThrowCondition(done);
        return done;
    }

    @Override
    protected void evaluateThrowCondition(Result r) {
    }

    @Override
    public DefaultSearchOperationHandle onResult(ResultHandler ... function) {
        super.onResult(function);
        return this;
    }

    @Override
    public DefaultSearchOperationHandle onControl(ResponseControlHandler ... function) {
        super.onControl(function);
        return this;
    }

    @Override
    public DefaultSearchOperationHandle onReferral(ReferralHandler ... function) {
        super.onReferral(function);
        return this;
    }

    @Override
    public DefaultSearchOperationHandle onIntermediate(IntermediateResponseHandler ... function) {
        super.onIntermediate(function);
        return this;
    }

    @Override
    public DefaultSearchOperationHandle onUnsolicitedNotification(UnsolicitedNotificationHandler ... function) {
        super.onUnsolicitedNotification(function);
        return this;
    }

    @Override
    public DefaultSearchOperationHandle onReferralResult(ReferralResultHandler<SearchResponse> function) {
        super.onReferralResult((ReferralResultHandler)function);
        return this;
    }

    @Override
    public DefaultSearchOperationHandle onException(ExceptionHandler function) {
        super.onException(function);
        return this;
    }

    @Override
    public DefaultSearchOperationHandle throwIf(ResultPredicate function) {
        super.throwIf(function);
        return this;
    }

    @Override
    public DefaultSearchOperationHandle onComplete(CompleteHandler function) {
        super.onComplete(function);
        return this;
    }

    @Override
    public DefaultSearchOperationHandle onEntry(LdapEntryHandler ... function) {
        this.onEntry = this.initializeMessageFunctional(function);
        return this;
    }

    @Override
    public DefaultSearchOperationHandle onReference(SearchReferenceHandler ... function) {
        this.onReference = this.initializeMessageFunctional(function);
        return this;
    }

    @Override
    public DefaultSearchOperationHandle onSearchResult(SearchResultHandler ... function) {
        this.onSearchResult = this.initializeMessageFunctional(function);
        return this;
    }

    public LdapEntryHandler[] getOnEntry() {
        return this.onEntry;
    }

    public SearchReferenceHandler[] getOnReference() {
        return this.onReference;
    }

    public SearchResultHandler[] getOnSearchResult() {
        return this.onSearchResult;
    }

    public void entry(LdapEntry r) {
        if (this.getMessageID().intValue() != r.getMessageID()) {
            IllegalArgumentException e = new IllegalArgumentException("Invalid entry " + r + " for handle " + this);
            this.notifyExceptionHandlers(new LdapException(e));
            throw e;
        }
        LdapEntry e = r;
        if (this.onEntry != null) {
            for (LdapEntryHandler func : this.onEntry) {
                try {
                    LdapEntry handlerEntry = (LdapEntry)func.apply(e);
                    if (handlerEntry == null) {
                        e = null;
                        break;
                    }
                    if (!handlerEntry.equalsMessage(e)) {
                        throw new IllegalStateException("Cannot modify entry instance with handler " + func);
                    }
                    e = handlerEntry;
                }
                catch (Exception ex) {
                    this.processHandlerException(ex);
                }
            }
        }
        ++this.entryCount;
        if (e != null) {
            this.result.addEntries(e);
        }
        this.consumedMessage(r);
    }

    public void reference(SearchResultReference r) {
        if (this.getMessageID().intValue() != r.getMessageID()) {
            IllegalArgumentException e = new IllegalArgumentException("Invalid reference " + r + " for handle " + this);
            this.notifyExceptionHandlers(new LdapException(e));
            throw e;
        }
        if (this.onReference != null) {
            for (SearchReferenceHandler func : this.onReference) {
                try {
                    func.accept(r);
                }
                catch (Exception ex) {
                    this.processHandlerException(ex);
                }
            }
        }
        this.result.addReferences(r);
        this.consumedMessage(r);
    }

    @Override
    public void result(SearchResponse r) {
        this.processResult(r);
        r.addEntries(this.result.getEntries());
        r.addReferences(this.result.getReferences());
        if (SORT_RESULTS) {
            this.finalizeResult(SearchResponse.sort(r));
        } else {
            this.finalizeResult(r);
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", entryCount=" + this.entryCount + ", onEntry=" + Arrays.toString(this.onEntry) + ", onReference=" + Arrays.toString(this.onReference) + ", onSearchResult=" + Arrays.toString(this.onSearchResult);
    }
}

