/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control.util;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.ldaptive.AbstractSearchOperationFactory;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.control.RequestControl;
import org.ldaptive.control.SortKey;
import org.ldaptive.control.SortRequestControl;
import org.ldaptive.control.VirtualListViewRequestControl;
import org.ldaptive.control.VirtualListViewResponseControl;
import org.ldaptive.control.util.VirtualListViewParams;
import org.ldaptive.handler.LdapEntryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualListViewClient
extends AbstractSearchOperationFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SortRequestControl sortControl;

    public VirtualListViewClient(ConnectionFactory cf, SortKey ... keys) {
        this.setConnectionFactory(cf);
        this.sortControl = new SortRequestControl(keys);
    }

    public SearchResponse execute(SearchRequest request, VirtualListViewParams params) throws LdapException {
        SearchOperation search = this.createSearchOperation();
        request.setControls(this.appendRequestControls(request, params.createRequestControl(true)));
        SearchResponse response = search.execute(request);
        byte[] cookie = this.getVirtualListViewCookie(response);
        if (cookie != null && params.getCookieManager() != null) {
            params.getCookieManager().writeCookie(cookie);
        }
        return response;
    }

    public SearchResponse execute(SearchRequest request, VirtualListViewParams params, SearchResponse result) throws LdapException {
        SearchOperation search = this.createSearchOperation();
        request.setControls(this.appendRequestControls(request, params.createRequestControl(result, true)));
        SearchResponse response = search.execute(request);
        byte[] cookie = this.getVirtualListViewCookie(response);
        if (cookie != null && params.getCookieManager() != null) {
            params.getCookieManager().writeCookie(cookie);
        }
        return response;
    }

    public SearchResponse executeToCompletion(SearchRequest request, VirtualListViewParams params) throws LdapException {
        int contentCount;
        ResultCode ctrlResult;
        byte[] cookie;
        SearchResponse result = null;
        SearchResponse combinedResults = new SearchResponse();
        SearchOperation search = this.createSearchOperation();
        AtomicInteger entryCount = new AtomicInteger();
        LdapEntryHandler[] handlers = search.getEntryHandlers();
        search.setEntryHandlers(LdapUtils.concatArrays(new LdapEntryHandler[]{e -> {
            entryCount.incrementAndGet();
            return e;
        }}, new LdapEntryHandler[][]{handlers}));
        VirtualListViewParams newParams = params;
        do {
            if (result != null) {
                combinedResults.addEntries(result.getEntries());
                combinedResults.addReferences(result.getReferences());
                newParams = new VirtualListViewParams(newParams.getTargetOffset() + newParams.getAfterCount() + 1, 0, params.getAfterCount());
                request.setControls(this.appendRequestControls(request, newParams.createRequestControl(result, true)));
            } else {
                request.setControls(this.appendRequestControls(request, newParams.createRequestControl(true)));
            }
            result = search.execute(request);
            VirtualListViewResponseControl ctrl = this.getResponseControl(result);
            contentCount = ctrl != null ? ctrl.getContentCount() : 0;
            cookie = ctrl != null ? ctrl.getContextID() : null;
            ResultCode resultCode = ctrlResult = ctrl != null ? ctrl.getViewResult() : null;
            if (cookie == null) continue;
            newParams.getCookieManager().writeCookie(cookie);
        } while (cookie != null && ResultCode.SUCCESS.equals((Object)ctrlResult) && contentCount > 0 && entryCount.get() < contentCount);
        SearchResponse finalResult = SearchResponse.copy(result);
        finalResult.addEntries(combinedResults.getEntries());
        finalResult.addReferences(combinedResults.getReferences());
        return finalResult;
    }

    public VirtualListViewResponseControl getResponseControl(SearchResponse result) {
        if (result == null) {
            return null;
        }
        return (VirtualListViewResponseControl)result.getControl("2.16.840.1.113730.3.4.10");
    }

    protected byte[] getVirtualListViewCookie(SearchResponse result) {
        if (result == null) {
            return null;
        }
        byte[] cookie = null;
        VirtualListViewResponseControl ctl = (VirtualListViewResponseControl)result.getControl("2.16.840.1.113730.3.4.10");
        if (ctl != null && ctl.getContextID() != null && ctl.getContextID().length > 0) {
            cookie = ctl.getContextID();
        }
        return cookie;
    }

    private RequestControl[] appendRequestControls(SearchRequest request, VirtualListViewRequestControl cntrl) {
        if (request.getControls() != null && request.getControls().length > 0) {
            List requestControls = Arrays.stream(request.getControls()).filter(c -> !(c instanceof VirtualListViewRequestControl) && !c.equals(this.sortControl)).collect(Collectors.toList());
            requestControls.add(this.sortControl);
            requestControls.add(cntrl);
            return (RequestControl[])requestControls.toArray(RequestControl[]::new);
        }
        return new RequestControl[]{this.sortControl, cntrl};
    }
}

