/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.net.InetAddress;
import org.ldaptive.LdapURLRetryMetadata;
import org.ldaptive.LdapUtils;
import org.ldaptive.url.DefaultUrlParser;
import org.ldaptive.url.Url;
import org.ldaptive.url.UrlParser;

public final class LdapURL {
    private static final int HASH_CODE_SEED = 10333;
    private Url url;
    private LdapURLRetryMetadata retryMetadata;
    private boolean active = true;
    private InetAddress inetAddress;
    private long priority;

    private LdapURL() {
    }

    private LdapURL(Url ldapURL) {
        if (ldapURL.getHostname() == null) {
            throw new IllegalArgumentException("Hostname cannot be null");
        }
        this.url = ldapURL;
    }

    public LdapURL(String hostname, int port) {
        this("ldap://" + (hostname != null ? hostname : "") + ":" + port);
    }

    public LdapURL(String ldapUrl) {
        this(ldapUrl, new DefaultUrlParser());
    }

    public LdapURL(String ldapUrl, UrlParser parser) {
        this(parser.parse(ldapUrl));
    }

    public String getScheme() {
        return this.url.getScheme();
    }

    public boolean isSchemeLdaps() {
        return this.url.isSchemeLdaps();
    }

    public String getHostname() {
        return this.url.getHostname();
    }

    public int getPort() {
        return this.url.getPort();
    }

    public Url getUrl() {
        return this.url;
    }

    public String getHostnameWithPort() {
        return this.getHostname() + ":" + this.getPort();
    }

    public String getHostnameWithSchemeAndPort() {
        return this.getScheme() + "://" + this.getHostname() + ":" + this.getPort();
    }

    LdapURLRetryMetadata getRetryMetadata() {
        return this.retryMetadata;
    }

    void setRetryMetadata(LdapURLRetryMetadata metadata) {
        this.retryMetadata = metadata;
    }

    boolean isActive() {
        return this.active;
    }

    void activate() {
        this.active = true;
    }

    void deactivate() {
        this.active = false;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    void setInetAddress(InetAddress address) {
        this.inetAddress = address;
    }

    public long getPriority() {
        return this.priority;
    }

    void setPriority(long p) {
        if (p < 0L) {
            throw new IllegalArgumentException("Priority cannot be negative");
        }
        this.priority = p;
    }

    public static LdapURL copy(LdapURL ldapURL) {
        LdapURL url = new LdapURL();
        url.url = ldapURL.url;
        url.retryMetadata = ldapURL.retryMetadata;
        url.active = ldapURL.active;
        url.inetAddress = ldapURL.inetAddress;
        return url;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LdapURL) {
            LdapURL v = (LdapURL)o;
            return LdapUtils.areEqual(this.url, v.url) && LdapUtils.areEqual(this.inetAddress, v.inetAddress);
        }
        return false;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(10333, this.url, this.inetAddress);
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::url=" + this.getHostnameWithSchemeAndPort() + ", inetAddress=" + this.inetAddress + "]";
    }
}

