/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import kafka.log.LogTestUtils$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.log.remote.RemoteLogManager;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.serializer.Decoder;
import kafka.serializer.IntegerDecoder;
import kafka.serializer.LongDecoder;
import kafka.serializer.StringDecoder;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaRaftServer$;
import kafka.server.RequestLocal;
import kafka.tools.BatchInfo;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.utils.TestUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.GzipCompression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.CoordinatorRecord;
import org.apache.kafka.coordinator.group.CoordinatorRecordSerde;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.internals.VoterSetTest;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tools.api.DefaultDecoder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Using;
import scala.util.Using$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\t}b\u0001\u0002\u001c8\u0001qBQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004R\u0001\u0001\u0006I!\u0013\u0005\b%\u0002\u0011\r\u0011\"\u0001I\u0011\u0019\u0019\u0006\u0001)A\u0005\u0013\"9A\u000b\u0001b\u0001\n\u0003)\u0006B\u0002/\u0001A\u0003%a\u000bC\u0004^\u0001\t\u0007I\u0011A+\t\ry\u0003\u0001\u0015!\u0003W\u0011\u001dy\u0006A1A\u0005\u0002UCa\u0001\u0019\u0001!\u0002\u00131\u0006bB1\u0001\u0005\u0004%\t!\u0016\u0005\u0007E\u0002\u0001\u000b\u0011\u0002,\t\u000f\r\u0004!\u0019!C\u0001+\"1A\r\u0001Q\u0001\nYCq!\u001a\u0001C\u0002\u0013\u0005a\r\u0003\u0004u\u0001\u0001\u0006Ia\u001a\u0005\bk\u0002\u0011\r\u0011\"\u0001w\u0011\u001d\t)\u0001\u0001Q\u0001\n]D1\"a\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\n!Y\u0011Q\u0003\u0001A\u0002\u0003\u0007I\u0011AA\f\u0011-\t\u0019\u0003\u0001a\u0001\u0002\u0003\u0006K!a\u0003\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!9\u0011q\b\u0001\u0005\u0002\u0005\u001d\u0002bBA!\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003\u0017\u0002A\u0011AA\u0014\u0011\u001d\t)\u0006\u0001C\u0001\u0003OAq!!\u0017\u0001\t\u0003\t9\u0003C\u0004\u0002^\u0001!\t!a\n\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002(!9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0002bBA5\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003[\u0002A\u0011BA8\u0011\u001d\ty\t\u0001C\u0001\u0003OAq!a%\u0001\t\u0003\t9\u0003C\u0004\u0002\u0018\u0002!\t!a\n\t\u000f\u0005m\u0005\u0001\"\u0001\u0002(!9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0006bBA\\\u0001\u0011%\u0011\u0011\u0018\u0005\b\u0003\u000f\u0004A\u0011BAe\u0011\u001d\ti\r\u0001C\u0005\u0003\u001fDq!!:\u0001\t\u0013\t9\u000fC\u0004\u0002t\u0002!I!a\n\b\u000f\u0005Ux\u0007#\u0001\u0002x\u001a1ag\u000eE\u0001\u0003sDaaQ\u0017\u0005\u0002\u0005mhABA\u007f[\u0001\ty\u0010\u0003\u0006\u0003\u0016=\u0012\t\u0011)A\u0005\u0005/AaaQ\u0018\u0005\u0002\t\r\u0002b\u0002B\u0016_\u0011\u0005#Q\u0006\u0004\u0007\u0005gi\u0003A!\u000e\t\r\r\u001bD\u0011\u0001B\u001c\u0011\u001d\u0011Yc\rC!\u0005w\u00111\u0003R;na2{wmU3h[\u0016tGo\u001d+fgRT!\u0001O\u001d\u0002\u000bQ|w\u000e\\:\u000b\u0003i\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001{A\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A#\u0011\u0005\u0019\u0003Q\"A\u001c\u0002\rQl\u0007\u000fR5s+\u0005I\u0005C\u0001&P\u001b\u0005Y%B\u0001'N\u0003\tIwNC\u0001O\u0003\u0011Q\u0017M^1\n\u0005A[%\u0001\u0002$jY\u0016\fq\u0001^7q\t&\u0014\b%\u0001\u0004m_\u001e$\u0015N]\u0001\bY><G)\u001b:!\u0003-\u0019XmZ7f]Rt\u0015-\\3\u0016\u0003Y\u0003\"a\u0016.\u000e\u0003aS!!W'\u0002\t1\fgnZ\u0005\u00037b\u0013aa\u0015;sS:<\u0017\u0001D:fO6,g\u000e\u001e(b[\u0016\u0004\u0013a\u00037pO\u001aKG.\u001a)bi\"\fA\u0002\\8h\r&dW\rU1uQ\u0002\nAb\u001d8baNDw\u000e\u001e)bi\"\fQb\u001d8baNDw\u000e\u001e)bi\"\u0004\u0013!D5oI\u0016Dh)\u001b7f!\u0006$\b.\u0001\bj]\u0012,\u0007PR5mKB\u000bG\u000f\u001b\u0011\u0002#QLW.Z%oI\u0016Dh)\u001b7f!\u0006$\b.\u0001\nuS6,\u0017J\u001c3fq\u001aKG.\u001a)bi\"\u0004\u0013\u0001\u0002;j[\u0016,\u0012a\u001a\t\u0003QJl\u0011!\u001b\u0006\u0003U.\fA!\u001e;jY*\u0011A.\\\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005ir'BA8q\u0003\u0019\t\u0007/Y2iK*\t\u0011/A\u0002pe\u001eL!a]5\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\nqAY1uG\",7/F\u0001x!\rAXp`\u0007\u0002s*\u0011!p_\u0001\b[V$\u0018M\u00197f\u0015\tax(\u0001\u0006d_2dWm\u0019;j_:L!A`=\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0004\r\u0006\u0005\u0011bAA\u0002o\tI!)\u0019;dQ&sgm\\\u0001\tE\u0006$8\r[3tA\u0005\u0019An\\4\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003#i!!a\u0004\u000b\u0007\u0005\u001d\u0011(\u0003\u0003\u0002\u0014\u0005=!AC+oS\u001aLW\r\u001a'pO\u00069An\\4`I\u0015\fH\u0003BA\r\u0003?\u00012APA\u000e\u0013\r\tib\u0010\u0002\u0005+:LG\u000fC\u0005\u0002\"U\t\t\u00111\u0001\u0002\f\u0005\u0019\u0001\u0010J\u0019\u0002\t1|w\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u00033A3aFA\u0016!\u0011\ti#a\u000f\u000e\u0005\u0005=\"\u0002BA\u0019\u0003g\t1!\u00199j\u0015\u0011\t)$a\u000e\u0002\u000f),\b/\u001b;fe*\u0019\u0011\u0011\b9\u0002\u000b),h.\u001b;\n\t\u0005u\u0012q\u0006\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001E1eINKW\u000e\u001d7f%\u0016\u001cwN\u001d3t\u0003!!X-\u0019:E_^t\u0007fA\r\u0002FA!\u0011QFA$\u0013\u0011\tI%a\f\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\t;fgR\u0014\u0015\r^2i\u0003:$'+Z2pe\u0012lU\r^1eCR\fw*\u001e;qkRD3AGA(!\u0011\ti#!\u0015\n\t\u0005M\u0013q\u0006\u0002\u0005)\u0016\u001cH/\u0001\tuKN$\bK]5oi\u0012\u000bG/\u0019'pO\"\u001a1$a\u0014\u0002/Q,7\u000f\u001e#v[BLe\u000eZ3y\u001b&\u001cX.\u0019;dQ\u0016\u001c\bf\u0001\u000f\u0002P\u00059B/Z:u\tVl\u0007\u000fV5nK&sG-\u001a=FeJ|'o\u001d\u0015\u0004;\u0005=\u0013a\u0006;fgR$U/\u001c9NKR\fG-\u0019;b%\u0016\u001cwN\u001d3tQ\rq\u0012qJ\u0001\u0019i\u0016\u001cH\u000fR;na6+G/\u00193bi\u0006\u001cf.\u00199tQ>$\bfA\u0010\u0002P\u0005\u0011B/Z:u\tVl\u0007/R7qifLe\u000eZ3yQ\r\u0001\u0013qJ\u0001\u0013eVtG)^7q\u0019><7+Z4nK:$8\u000f\u0006\u0003\u0002r\u0005\u0015\u0005\u0003BA:\u0003\u0003sA!!\u001e\u0002~A\u0019\u0011qO \u000e\u0005\u0005e$bAA>w\u00051AH]8pizJ1!a @\u0003\u0019\u0001&/\u001a3fM&\u00191,a!\u000b\u0007\u0005}t\bC\u0004\u0002\b\u0006\u0002\r!!#\u0002\t\u0005\u0014xm\u001d\t\u0006}\u0005-\u0015\u0011O\u0005\u0004\u0003\u001b{$!B!se\u0006L\u0018A\b;fgR\u0004&/\u001b8u\t\u0006$\u0018\rT8h!\u0006\u0014H/[1m\u0005\u0006$8\r[3tQ\r\u0011\u0013qJ\u0001\u0019i\u0016\u001cHo\u00144gg\u0016$8/T3tg\u0006<W\rU1sg\u0016\u0014\bfA\u0012\u0002P\u0005qA/Z:u\u001d\u0016<H)Z2pI\u0016\u0014\bf\u0001\u0013\u0002P\u0005\tC/Z:u\u0007>tg/\u001a:u\t\u0016\u0004(/Z2bi\u0016$G)Z2pI\u0016\u00148\t\\1tg\"\u001aQ%a\u0014\u0002#I,\u0017\r\u001a\"bi\u000eDW*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0002$\u0006%\u0006#\u0002 \u0002&\u0006E\u0014bAAT\u007f\t1q\n\u001d;j_:Dq!a+'\u0001\u0004\ti+A\u0003mS:,7\u000f\u0005\u0004\u00020\u0006M\u0016\u0011O\u0007\u0003\u0003cS!A['\n\t\u0005U\u0016\u0011\u0017\u0002\r\u0019&\u001cH/\u0013;fe\u0006$xN]\u0001\u0018e\u0016\fG\rU1si&\fGNQ1uG\",7OQ=uKN$b!a/\u0002B\u0006\r\u0007c\u0001 \u0002>&\u0019\u0011qX \u0003\u0007%sG\u000fC\u0004\u0002,\u001e\u0002\r!!,\t\u000f\u0005\u0015w\u00051\u0001\u0002<\u0006)A.[7ji\u0006a1m\\;oi\n\u000bGo\u00195fgR!\u00111XAf\u0011\u001d\tY\u000b\u000ba\u0001\u0003[\u000b\u0001C]3bI\n\u000bGo\u00195SK\u000e|'\u000fZ:\u0015\t\u0005E\u00171\u001d\t\u0007\u0003'\fi.!\u001d\u000f\t\u0005U\u0017\u0011\u001c\b\u0005\u0003o\n9.C\u0001A\u0013\r\tYnP\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty.!9\u0003\u0007M+\u0017OC\u0002\u0002\\~Bq!a+*\u0001\u0004\ti+A\nqCJ\u001cX-T3uC\u0012\fG/\u0019$jK2$7\u000f\u0006\u0003\u0002j\u0006=\b\u0003CA:\u0003W\f\t(!\u001d\n\t\u00055\u00181\u0011\u0002\u0004\u001b\u0006\u0004\bbBAyU\u0001\u0007\u0011\u0011O\u0001\u0005Y&tW-A\u000ebgN,'\u000f\u001e#v[Bdun\u001a*fG>\u0014H-T3uC\u0012\fG/Y\u0001\u0014\tVl\u0007\u000fT8h'\u0016<W.\u001a8ugR+7\u000f\u001e\t\u0003\r6\u001a\"!L\u001f\u0015\u0005\u0005](a\u0003+fgR$UmY8eKJ\u001cBaL\u001f\u0003\u0002A1!1\u0001B\u0005\u0005\u001bi!A!\u0002\u000b\u0007\t\u001d\u0011(\u0001\u0006tKJL\u0017\r\\5{KJLAAa\u0003\u0003\u0006\t9A)Z2pI\u0016\u0014\b#\u0002 \u0002\f\n=\u0001c\u0001 \u0003\u0012%\u0019!1C \u0003\t\tKH/Z\u0001\u0006aJ|\u0007o\u001d\t\u0005\u00053\u0011y\"\u0004\u0002\u0003\u001c)\u0019!QD\u001d\u0002\u000bU$\u0018\u000e\\:\n\t\t\u0005\"1\u0004\u0002\u0015-\u0016\u0014\u0018NZ5bE2,\u0007K]8qKJ$\u0018.Z:\u0015\t\t\u0015\"\u0011\u0006\t\u0004\u0005OyS\"A\u0017\t\u000f\tU\u0011\u00071\u0001\u0003\u0018\u0005IaM]8n\u0005f$Xm\u001d\u000b\u0005\u0005\u001b\u0011y\u0003C\u0004\u00032I\u0002\rA!\u0004\u0002\u000b\tLH/Z:\u0003MQ+7\u000f\u001e#fG>$WM],ji\"|W\u000f\u001e,fe&4\u0017.\u00192mKB\u0013x\u000e]3si&,7o\u0005\u00034{\t\u0005AC\u0001B\u001d!\r\u00119c\r\u000b\u0005\u0005\u001b\u0011i\u0004C\u0004\u00032U\u0002\rA!\u0004")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String segmentName;
    private final String logFilePath = new StringBuilder(5).append(this.logDir()).append("/").append(this.segmentName()).append(".log").toString();
    private final String snapshotPath = new StringBuilder(43).append(this.logDir()).append("/00000000000000000000-0000000000.checkpoint").toString();
    private final String indexFilePath = new StringBuilder(7).append(this.logDir()).append("/").append(this.segmentName()).append(".index").toString();
    private final String timeIndexFilePath = new StringBuilder(11).append(this.logDir()).append("/").append(this.segmentName()).append(".timeindex").toString();
    private final MockTime time = new MockTime(0L, 0L);
    private final ArrayBuffer<BatchInfo> batches = new ArrayBuffer();
    private UnifiedLog log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String snapshotPath() {
        return this.snapshotPath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public ArrayBuffer<BatchInfo> batches() {
        return this.batches;
    }

    public UnifiedLog log() {
        return this.log;
    }

    public void log_$eq(UnifiedLog x$1) {
        this.log = x$1;
    }

    @BeforeEach
    public void setUp() {
        Properties props = new Properties();
        props.setProperty("index.interval.bytes", "128");
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)props);
        MockScheduler x$5 = this.time().scheduler;
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats(false);
        ProducerStateManagerConfig x$9 = new ProducerStateManagerConfig(86400000, false);
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$14 = true;
        ConcurrentHashMap x$15 = new ConcurrentHashMap();
        boolean x$16 = false;
        LogOffsetsListener x$17 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        this.log_$eq(UnifiedLog$.MODULE$.apply(x$1, x$2, 0L, 0L, (Scheduler)x$5, x$7, (Time)x$6, 300000, x$9, 600000, x$11, x$14, (Option)x$12, true, x$15, x$16, x$17));
    }

    public void addSimpleRecords() {
        long now = System.currentTimeMillis();
        IndexedSeq firstBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$1(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((scala.collection.immutable.Seq<SimpleRecord>)firstBatchRecords, true, true));
        IndexedSeq secondBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(10), 30).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$2(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((scala.collection.immutable.Seq<SimpleRecord>)secondBatchRecords, true, false));
        IndexedSeq thirdBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(30), 50).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$3(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((scala.collection.immutable.Seq<SimpleRecord>)thirdBatchRecords, false, true));
        IndexedSeq fourthBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(50), 60).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$4(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((scala.collection.immutable.Seq<SimpleRecord>)fourthBatchRecords, false, false));
        this.batches().foreach((Function1 & Serializable)batchInfo -> {
            void withRecords_records;
            void withRecords_partitionLeaderEpoch;
            UnifiedLog qual$1 = this.log();
            SimpleRecord[] simpleRecordArray = (SimpleRecord[])batchInfo.records().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
            boolean bl = false;
            NoCompression withRecords_compression = Compression.NONE;
            Object var8_5 = null;
            simpleRecordArray = null;
            MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
            AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
            MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
            RequestLocal x$5 = qual$1.appendAsLeader$default$5();
            VerificationGuard x$6 = qual$1.appendAsLeader$default$6();
            return qual$1.appendAsLeader(x$1, 0, x$3, x$4, x$5, x$6);
        });
        this.log().flush(false);
    }

    @AfterEach
    public void tearDown() {
        Utils.closeQuietly((AutoCloseable)this.log(), (String)"UnifiedLog");
        Utils.delete((File)this.tmpDir());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBatchAndRecordMetadataOutput() {
        void withTransactionalRecords_records;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_producerEpoch;
        void withTransactionalRecords_producerId;
        void withIdempotentRecords_records;
        void withIdempotentRecords_baseSequence;
        void withIdempotentRecords_producerEpoch;
        void withIdempotentRecords_producerId;
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_records3;
        void withRecords_partitionLeaderEpoch3;
        UnifiedLog qual$1 = this.log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        boolean bl = false;
        NoCompression withRecords_compression = Compression.NONE;
        Object var36_4 = null;
        simpleRecordArray = null;
        MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withRecords_records3);
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$6 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$1, 0, x$3, x$4, x$5, x$6);
        UnifiedLog qual$2 = this.log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "c".getBytes(), "1".getBytes()), new SimpleRecord("d".getBytes())};
        boolean bl2 = false;
        GzipCompression withRecords_compression2 = new GzipCompression.Builder().build();
        Object var39_13 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$7 = MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withRecords_compression2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2);
        AppendOrigin x$9 = qual$2.appendAsLeader$default$3();
        MetadataVersion x$10 = qual$2.appendAsLeader$default$4();
        RequestLocal x$11 = qual$2.appendAsLeader$default$5();
        VerificationGuard x$12 = qual$2.appendAsLeader$default$6();
        qual$2.appendAsLeader(x$7, 3, x$9, x$10, x$11, x$12);
        UnifiedLog qual$3 = this.log();
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord("e".getBytes(), null), new SimpleRecord(null, "f".getBytes()), new SimpleRecord("g".getBytes())};
        boolean bl3 = false;
        NoCompression withRecords_compression3 = Compression.NONE;
        Object var42_22 = null;
        simpleRecordArray3 = null;
        MemoryRecords x$13 = MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withRecords_compression3, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
        AppendOrigin x$15 = qual$3.appendAsLeader$default$3();
        MetadataVersion x$16 = qual$3.appendAsLeader$default$4();
        RequestLocal x$17 = qual$3.appendAsLeader$default$5();
        VerificationGuard x$18 = qual$3.appendAsLeader$default$6();
        qual$3.appendAsLeader(x$13, 3, x$15, x$16, x$17, x$18);
        UnifiedLog qual$4 = this.log();
        SimpleRecord[] simpleRecordArray4 = new SimpleRecord[]{new SimpleRecord("h".getBytes())};
        int n = 234123;
        short s = (short)15;
        long l = 29342342L;
        NoCompression withIdempotentRecords_compression = Compression.NONE;
        Object var45_33 = null;
        simpleRecordArray4 = null;
        MemoryRecords x$19 = MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withIdempotentRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId, (short)withIdempotentRecords_producerEpoch, (int)withIdempotentRecords_baseSequence, (int)-1, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        AppendOrigin x$21 = qual$4.appendAsLeader$default$3();
        MetadataVersion x$22 = qual$4.appendAsLeader$default$4();
        RequestLocal x$23 = qual$4.appendAsLeader$default$5();
        VerificationGuard x$24 = qual$4.appendAsLeader$default$6();
        qual$4.appendAsLeader(x$19, 3, x$21, x$22, x$23, x$24);
        UnifiedLog qual$5 = this.log();
        SimpleRecord[] simpleRecordArray5 = new SimpleRecord[]{new SimpleRecord("i".getBytes()), new SimpleRecord("j".getBytes())};
        int n2 = 266;
        short s2 = (short)99;
        long l2 = 98323L;
        GzipCompression withTransactionalRecords_compression = new GzipCompression.Builder().build();
        Object var51_44 = null;
        simpleRecordArray5 = null;
        MemoryRecords x$25 = MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withTransactionalRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId, (short)withTransactionalRecords_producerEpoch, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
        AppendOrigin x$27 = qual$5.appendAsLeader$default$3();
        MetadataVersion x$28 = qual$5.appendAsLeader$default$4();
        RequestLocal x$29 = qual$5.appendAsLeader$default$5();
        VerificationGuard x$30 = qual$5.appendAsLeader$default$6();
        qual$5.appendAsLeader(x$25, 5, x$27, x$28, x$29, x$30);
        UnifiedLog qual$6 = this.log();
        MemoryRecords x$31 = MemoryRecords.withEndTransactionMarker((long)98323L, (short)((short)99), (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 100));
        MetadataVersion x$34 = qual$6.appendAsLeader$default$4();
        RequestLocal x$35 = qual$6.appendAsLeader$default$5();
        VerificationGuard x$36 = qual$6.appendAsLeader$default$6();
        qual$6.appendAsLeader(x$31, 7, AppendOrigin.COORDINATOR, x$34, x$35, x$36);
        this.assertDumpLogRecordMetadata();
    }

    @Test
    public void testPrintDataLog() {
        this.addSimpleRecords();
        this.verifyRecordsInOutput$1(true, new String[]{"--print-data-log", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(false, new String[]{"--deep-iteration", "--files", this.logFilePath()});
        this.verifyNoRecordsInOutput$1(new String[]{"--files", this.logFilePath()});
    }

    @Test
    public void testDumpIndexMismatches() {
        this.addSimpleRecords();
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        this.addSimpleRecords();
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpMetadataRecords() {
        void withRecords_timestampType;
        void withRecords_records;
        void withRecords_timestampType2;
        void withRecords_timestampType3;
        MockTime mockTime = new MockTime();
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(false), (Scheduler)mockTime.scheduler, (Time)mockTime, 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), 86400000, true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Object>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER));
        SimpleRecord[] records = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (short)0), (List)Nil$.MODULE$)))).map((Function1 & Serializable)message -> {
            MetadataRecordSerde serde = MetadataRecordSerde.INSTANCE;
            ObjectSerializationCache cache = new ObjectSerializationCache();
            ByteBuffer buf = ByteBuffer.allocate(serde.recordSize(message, cache));
            ByteBufferAccessor writer = new ByteBufferAccessor(buf);
            serde.write(message, cache, (Writable)writer);
            buf.flip();
            return new SimpleRecord(null, buf.array());
        })).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        UnifiedLog qual$1 = this.log();
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var44_17 = null;
        MemoryRecords x$14 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType3, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records);
        AppendOrigin x$16 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$17 = qual$1.appendAsLeader$default$4();
        RequestLocal x$18 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$19 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$14, 1, x$16, x$17, x$18, x$19);
        this.log().flush(false);
        String output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        ByteBuffer buf = ByteBuffer.allocate(4);
        ByteBufferAccessor writer = new ByteBufferAccessor(buf);
        writer.writeUnsignedVarint(10000);
        writer.writeUnsignedVarint(10000);
        UnifiedLog qual$2 = this.log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(null, buf.array())};
        NoCompression withRecords_compression2 = Compression.NONE;
        byte withRecords_magic2 = 2;
        TimestampType timestampType2 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset2 = 0L;
        timestampType2 = null;
        Object var45_31 = null;
        simpleRecordArray = null;
        MemoryRecords x$20 = MemoryRecords.withRecords((byte)withRecords_magic2, (long)withRecords_initialOffset2, (Compression)withRecords_compression2, (TimestampType)withRecords_timestampType2, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        AppendOrigin x$22 = qual$2.appendAsLeader$default$3();
        MetadataVersion x$23 = qual$2.appendAsLeader$default$4();
        RequestLocal x$24 = qual$2.appendAsLeader$default$5();
        VerificationGuard x$25 = qual$2.appendAsLeader$default$6();
        qual$2.appendAsLeader(x$20, 2, x$22, x$23, x$24, x$25);
        UnifiedLog qual$3 = this.log();
        NoCompression withRecords_compression3 = Compression.NONE;
        byte withRecords_magic3 = 2;
        TimestampType timestampType3 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset3 = 0L;
        timestampType3 = null;
        Object var47_41 = null;
        MemoryRecords x$26 = MemoryRecords.withRecords((byte)withRecords_magic3, (long)withRecords_initialOffset3, (Compression)withRecords_compression3, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records);
        AppendOrigin x$28 = qual$3.appendAsLeader$default$3();
        MetadataVersion x$29 = qual$3.appendAsLeader$default$4();
        RequestLocal x$30 = qual$3.appendAsLeader$default$5();
        VerificationGuard x$31 = qual$3.appendAsLeader$default$6();
        qual$3.appendAsLeader(x$26, 2, x$28, x$29, x$30, x$31);
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertTrue((boolean)output.contains("skipping"));
    }

    @Test
    public void testDumpMetadataSnapshot() {
        .colon.colon metadataRecords = new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (short)0), (List)Nil$.MODULE$))));
        KafkaMetadataLog metadataLog = KafkaMetadataLog$.MODULE$.apply(KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.logDir(), (Time)this.time(), (Scheduler)this.time().scheduler, new MetadataLogConfig(102400, 102400, 10000L, 102400L, 60000L, 0x800000, 0x800000, 60000L, 1));
        int lastContainedLogTimestamp = 10000;
        Using$.MODULE$.apply((Function0 & Serializable)() -> new RecordsSnapshotWriter.Builder().setTime((Time)new MockTime()).setLastContainedLogTimestamp((long)lastContainedLogTimestamp).setRawSnapshotWriter((RawSnapshotWriter)metadataLog.createNewSnapshot(new OffsetAndEpoch(0L, 0)).get()).setKraftVersion((short)1).setVoterSet(Optional.of(VoterSetTest.voterSet((Map)VoterSetTest.voterMap((IntStream)IntStream.of(1, 2, 3), (boolean)true)))).build((RecordSerde)MetadataRecordSerde.INSTANCE), arg_0 -> DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2$adapted((scala.collection.immutable.Seq)metadataRecords, arg_0), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        String output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--files", this.snapshotPath()});
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"), (String)output);
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"), (String)output);
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"), (String)output);
        Assertions.assertTrue((boolean)output.contains("SnapshotHeader"), (String)output);
        Assertions.assertTrue((boolean)output.contains("SnapshotFooter"), (String)output);
        Assertions.assertTrue((boolean)output.contains("KRaftVersion"), (String)output);
        Assertions.assertTrue((boolean)output.contains("KRaftVoters"), (String)output);
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(28).append("\"lastContainedLogTimestamp\":").append(lastContainedLogTimestamp).toString()), (String)output);
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.snapshotPath()});
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"), (String)output);
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"), (String)output);
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"), (String)output);
        Assertions.assertFalse((boolean)output.contains("SnapshotHeader"), (String)output);
        Assertions.assertFalse((boolean)output.contains("SnapshotFooter"), (String)output);
        Assertions.assertFalse((boolean)output.contains("KRaftVersion"), (String)output);
        Assertions.assertFalse((boolean)output.contains("KRaftVoters"), (String)output);
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(29).append("\"lastContainedLogTimestamp\": ").append(lastContainedLogTimestamp).toString()), (String)output);
    }

    @Test
    public void testDumpEmptyIndex() {
        File indexFile = new File(this.indexFilePath());
        new PrintWriter(indexFile).close();
        String expectOutput = new StringBuilder(11).append(indexFile).append(" is empty.\n").toString();
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpLogSegments$.MODULE$.dumpIndex(indexFile, false, true, (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), Integer.MAX_VALUE));
        Assertions.assertEquals((Object)expectOutput, (Object)outContent.toString());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        return outContent.toString();
    }

    @Test
    public void testPrintDataLogPartialBatches() {
        this.addSimpleRecords();
        int partialBatches = this.batches().size() / 2;
        ListIterator<String> lines = Arrays.asList(this.runDumpLogSegments(new String[]{"--files", this.logFilePath()}).split("\n")).listIterator();
        int partialBatchesBytes = this.readPartialBatchesBytes(lines, partialBatches);
        ListIterator<String> partialLines = Arrays.asList(this.runDumpLogSegments(new String[]{"--max-bytes", Integer.toString(partialBatchesBytes), "--files", this.logFilePath()}).split("\n")).listIterator();
        int partialBatchesCount = this.countBatches(partialLines);
        Assertions.assertEquals((int)partialBatches, (int)partialBatchesCount);
    }

    @Test
    public void testOffsetsMessageParser() {
        CoordinatorRecordSerde serde = new CoordinatorRecordSerde();
        DumpLogSegments.OffsetsMessageParser parser = new DumpLogSegments.OffsetsMessageParser();
        Assertions.assertEquals((Object)"Failed to decode message at offset 0 using offset topic decoder (message had a missing key)", (Object)Assertions.assertThrows(RuntimeException.class, () -> {
            NoCompression x$3 = Compression.NONE;
            long x$4 = -1L;
            byte x$5 = 2;
            parser.parse((Record)TestUtils$.MODULE$.singletonRecords(null, null, (Compression)x$3, x$4, x$5).records().iterator().next());
        }).getMessage());
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"3\",\"data\":{\"groupId\":\"group\"}}"), (Object)new Some((Object)"{\"version\":\"0\",\"data\":{\"epoch\":10}}")), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), (short)3), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), (short)0), serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"2\",\"data\":{\"group\":\"group\"}}"), (Object)new Some((Object)"{\"version\":\"4\",\"data\":{\"protocolType\":\"consumer\",\"generation\":10,\"protocol\":\"range\",\"leader\":\"member\",\"currentStateTimestamp\":-1,\"members\":[{\"memberId\":\"member\",\"groupInstanceId\":\"instance\",\"clientId\":\"client\",\"clientHost\":\"host\",\"rebalanceTimeout\":1000,\"sessionTimeout\":100,\"subscription\":{\"topics\":[\"foo\"],\"userData\":null,\"ownedPartitions\":[{\"topic\":\"foo\",\"partitions\":[0]}],\"generationId\":0,\"rackId\":\"rack\"},\"assignment\":{\"assignedPartitions\":[{\"topic\":\"foo\",\"partitions\":[0]}],\"userData\":null}}]}}")), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup("group"), (short)2), new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocolType("consumer").setProtocol("range").setLeader("member").setGeneration(10).setMembers(Collections.singletonList(new GroupMetadataValue.MemberMetadata().setMemberId("member").setClientId("client").setClientHost("host").setGroupInstanceId("instance").setSessionTimeout(100).setRebalanceTimeout(1000).setSubscription(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Collections.singletonList("foo"), null, Collections.singletonList(new TopicPartition("foo", 0)), 0, Optional.of("rack")), (short)3))).setAssignment(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(Collections.singletonList(new TopicPartition("foo", 0))), (short)3))))), 4), serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"2\",\"data\":{\"group\":\"group\"}}"), (Object)new Some((Object)"{\"version\":\"4\",\"data\":{\"protocolType\":\"consumer\",\"generation\":10,\"protocol\":\"range\",\"leader\":\"member\",\"currentStateTimestamp\":-1,\"members\":[{\"memberId\":\"member\",\"groupInstanceId\":\"instance\",\"clientId\":\"client\",\"clientHost\":\"host\",\"rebalanceTimeout\":1000,\"sessionTimeout\":100,\"subscription\":\"U3Vic2NyaXB0aW9u\",\"assignment\":\"QXNzaWdubWVudA==\"}]}}")), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup("group"), (short)2), new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocolType("consumer").setProtocol("range").setLeader("member").setGeneration(10).setMembers(Collections.singletonList(new GroupMetadataValue.MemberMetadata().setMemberId("member").setClientId("client").setClientHost("host").setGroupInstanceId("instance").setSessionTimeout(100).setRebalanceTimeout(1000).setSubscription("Subscription".getBytes()).setAssignment("Assignment".getBytes()))), 4), serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"3\",\"data\":{\"groupId\":\"group\"}}"), (Object)new Some((Object)"<DELETE>")), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), (short)3), null, serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"Unknown record type 32767 at offset 0, skipping."), (Object)None$.MODULE$), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), Short.MAX_VALUE), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), (short)0), serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"Error at offset 0, skipping. Could not read record with version 0 from value's buffer due to: Error reading byte array of 536870911 byte(s): only 1 byte(s) available."), (Object)None$.MODULE$), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), (short)3), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMemberMetadataValue(), (short)0), serde)));
    }

    @Test
    public void testNewDecoder() {
        DumpLogSegments$.MODULE$.newDecoder(TestDecoder.class.getName());
        DumpLogSegments$.MODULE$.newDecoder(kafka.serializer.DefaultDecoder.class.getName());
        Assertions.assertThrows(Exception.class, () -> DumpLogSegments$.MODULE$.newDecoder(TestDecoderWithoutVerifiableProperties.class.getName()));
    }

    @Test
    public void testConvertDeprecatedDecoderClass() {
        Assertions.assertEquals((Object)DefaultDecoder.class.getName(), (Object)DumpLogSegments$.MODULE$.convertDeprecatedDecoderClass(kafka.serializer.DefaultDecoder.class.getName()));
        Assertions.assertEquals((Object)org.apache.kafka.tools.api.IntegerDecoder.class.getName(), (Object)DumpLogSegments$.MODULE$.convertDeprecatedDecoderClass(IntegerDecoder.class.getName()));
        Assertions.assertEquals((Object)org.apache.kafka.tools.api.LongDecoder.class.getName(), (Object)DumpLogSegments$.MODULE$.convertDeprecatedDecoderClass(LongDecoder.class.getName()));
        Assertions.assertEquals((Object)org.apache.kafka.tools.api.StringDecoder.class.getName(), (Object)DumpLogSegments$.MODULE$.convertDeprecatedDecoderClass(StringDecoder.class.getName()));
    }

    private Option<String> readBatchMetadata(ListIterator<String> lines) {
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                throw new IllegalStateException("Read unexpected record entry");
            }
            if (!line.startsWith("baseOffset")) continue;
            return new Some((Object)line);
        }
        return None$.MODULE$;
    }

    private int readPartialBatchesBytes(ListIterator<String> lines, int limit) {
        Regex sizePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".+?size:\\s(\\d+).+"));
        int batchesBytes = 0;
        int batchesCounter = 0;
        while (lines.hasNext()) {
            if (batchesCounter >= limit) {
                return batchesBytes;
            }
            String line = lines.next();
            if (!line.startsWith("baseOffset")) continue;
            Option option = sizePattern.unapplySeq((CharSequence)line);
            if (!option.isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                String size = (String)((LinearSeqOps)option.get()).apply(0);
                batchesBytes += StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(size));
            } else {
                throw new IllegalStateException(new StringBuilder(52).append("Failed to parse and find size value for batch line: ").append(line).toString());
            }
            ++batchesCounter;
        }
        return batchesBytes;
    }

    private int countBatches(ListIterator<String> lines) {
        int countBatches = 0;
        while (lines.hasNext()) {
            if (!lines.next().startsWith("baseOffset")) continue;
            ++countBatches;
        }
        return countBatches;
    }

    private scala.collection.immutable.Seq<String> readBatchRecords(ListIterator<String> lines) {
        ArrayBuffer records = ArrayBuffer$.MODULE$.empty();
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                records.$plus$eq((Object)line.substring(1));
                continue;
            }
            lines.previous();
            return records.toSeq();
        }
        return records.toSeq();
    }

    private scala.collection.immutable.Map<String, String> parseMetadataFields(String line) {
        scala.collection.mutable.Map fields = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Iterator tokens = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+")), (Function1 & Serializable)x$4 -> x$4.trim(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$5))))));
        while (tokens.hasNext()) {
            String token = (String)tokens.next();
            if (!token.endsWith(":")) {
                throw new IllegalStateException(new StringBuilder(27).append("Unexpected non-field token ").append(token).toString());
            }
            String field = token.substring(0, token.length() - 1);
            if (!tokens.hasNext()) {
                throw new IllegalStateException(new StringBuilder(26).append("Failed to parse value for ").append(field).toString());
            }
            String value = (String)tokens.next();
            fields.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field), (Object)value));
        }
        return fields.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void assertDumpLogRecordMetadata() {
        FetchDataInfo logReadInfo = this.log().read(0L, Integer.MAX_VALUE, FetchIsolation.LOG_END, true);
        ListIterator<String> lines = Arrays.asList(this.runDumpLogSegments(new String[]{"--deep-iteration", "--files", this.logFilePath()}).split("\n")).listIterator();
        CollectionConverters$.MODULE$.IterableHasAsScala(logReadInfo.records.batches()).asScala().foreach((Function1 & Serializable)batch -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$1(this, lines, batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$1(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 2), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$2(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 3), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), null);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$3(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 5), null, new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$4(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 7), null);
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$1(IntRef i$1, int index$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            BatchInfo batch = (BatchInfo)x0$1._1();
            if (i$1.elem == index$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            ++i$1.elem;
            batch.records().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                if (i$1.elem == index$1) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
                ++i$1.elem;
            });
            return;
        }
        throw new MatchError(null);
    }

    private final boolean isBatch$1(int index) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((IterableOnceOps)this.batches().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                DumpLogSegmentsTest.$anonfun$testPrintDataLog$1(i, index, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw new AssertionError((Object)new StringBuilder(19).append("No match for index ").append(index).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ int $anonfun$testPrintDataLog$3(BatchInfo x$3) {
        return x$3.records().size();
    }

    private final void verifyRecordsInOutput$1(boolean checkKeysAndValues, String[] args) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 2 ? 1 : 0) != 0, (String)new StringBuilder(18).append("Data not printed: ").append(output).toString());
        int totalRecords = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.batches().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$testPrintDataLog$3(x$3)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        Iterator batchIterator = this.batches().iterator();
        ObjectRef batch = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), totalRecords + this.batches().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            String line = lines[lines.length - totalRecords - this.batches().size() + index];
            if (this.isBatch$1(index)) {
                Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(25).append("baseOffset: ").append(offset$1.elem).append(" lastOffset: ").toString()), (String)new StringBuilder(40).append("Not a valid batch-level message record: ").append(line).toString());
                batch$1.elem = (BatchInfo)batchIterator.next();
                return;
            }
            Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(9).append(DumpLogSegments$.MODULE$.RecordIndent()).append(" offset: ").append(offset$1.elem).toString()), (String)new StringBuilder(28).append("Not a valid message record: ").append(line).toString());
            if (checkKeysAndValues) {
                String suffix = "headerKeys: []";
                if (((BatchInfo)batch$1.elem).hasKeys()) {
                    suffix = new StringBuilder(18).append(suffix).append(" key: message key ").append(offset$1.elem).toString();
                }
                if (((BatchInfo)batch$1.elem).hasValues()) {
                    suffix = new StringBuilder(24).append(suffix).append(" payload: message value ").append(offset$1.elem).toString();
                }
                Assertions.assertTrue((boolean)line.endsWith(suffix), (String)new StringBuilder(37).append("Message record missing key or value: ").append(line).toString());
            }
            ++offset$1.elem;
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assertions.assertFalse((boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"), (String)new StringBuilder(35).append("Data should not have been printed: ").append(output).toString());
    }

    public static final /* synthetic */ long $anonfun$testDumpMetadataSnapshot$2(scala.collection.immutable.Seq metadataRecords$1, RecordsSnapshotWriter snapshotWriter) {
        snapshotWriter.append(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)metadataRecords$1).asJava());
        return snapshotWriter.freeze();
    }

    private static final Record serializedRecord$1(ApiMessageAndVersion key, ApiMessageAndVersion value, CoordinatorRecordSerde serde$1) {
        CoordinatorRecord record = new CoordinatorRecord(key, value);
        byte[] x$1 = serde$1.serializeKey(record);
        byte[] x$2 = serde$1.serializeValue(record);
        NoCompression x$3 = Compression.NONE;
        long x$4 = -1L;
        byte x$5 = 2;
        return (Record)TestUtils$.MODULE$.singletonRecords(x$2, x$1, (Compression)x$3, x$4, x$5).records().iterator().next();
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$11(DumpLogSegmentsTest $this, Iterator parsedRecordIter$1, RecordBatch batch$2, Record record) {
        Assertions.assertTrue((boolean)parsedRecordIter$1.hasNext());
        scala.collection.immutable.Map<String, String> parsedRecord = $this.parseMetadataFields((String)parsedRecordIter$1.next());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.offset())), (Object)parsedRecord.get((Object)"offset").map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$15)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.keySize())), (Object)parsedRecord.get((Object)"keySize").map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$16)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.valueSize())), (Object)parsedRecord.get((Object)"valueSize").map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$17)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.timestamp())), (Object)parsedRecord.get((Object)batch$2.timestampType().name).map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$18)))));
        if (batch$2.magic() >= RecordVersion.V2.value) {
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.sequence())), (Object)parsedRecord.get((Object)"sequence").map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$19)))));
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"lastOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"partitionLeaderEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerId"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseSequence"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isTransactional"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isControl"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"compresscodec"));
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$1(DumpLogSegmentsTest $this, ListIterator lines$2, RecordBatch batch) {
        Option<String> parsedBatchOpt = $this.readBatchMetadata(lines$2);
        Assertions.assertTrue((boolean)parsedBatchOpt.isDefined());
        scala.collection.immutable.Map<String, String> parsedBatch = $this.parseMetadataFields((String)parsedBatchOpt.get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.baseOffset())), (Object)parsedBatch.get((Object)"baseOffset").map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$6)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.lastOffset())), (Object)parsedBatch.get((Object)"lastOffset").map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$7)))));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)batch.countOrNull()), (Object)parsedBatch.get((Object)"count").map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$8)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch())), (Object)parsedBatch.get((Object)"partitionLeaderEpoch").map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$9)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional())), (Object)parsedBatch.get((Object)"isTransactional").map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$10)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())), (Object)parsedBatch.get((Object)"isControl").map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$11)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)parsedBatch.get((Object)"producerId").map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$12)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)batch.producerEpoch())), (Object)parsedBatch.get((Object)"producerEpoch").map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(x$13)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.baseSequence())), (Object)parsedBatch.get((Object)"baseSequence").map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$14)))));
        Assertions.assertEquals((Object)new Some((Object)batch.compressionType().name), (Object)parsedBatch.get((Object)"compresscodec"));
        Iterator parsedRecordIter = $this.readBatchRecords(lines$2).iterator();
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$11($this, parsedRecordIter, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
    }

    public static final /* synthetic */ Object $anonfun$testDumpMetadataSnapshot$2$adapted(scala.collection.immutable.Seq metadataRecords$1, RecordsSnapshotWriter snapshotWriter) {
        return BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2(metadataRecords$1, snapshotWriter));
    }

    public static class TestDecoder
    implements Decoder<byte[]> {
        public byte[] fromBytes(byte[] bytes) {
            return bytes;
        }

        public TestDecoder(VerifiableProperties props) {
        }
    }

    public static class TestDecoderWithoutVerifiableProperties
    implements Decoder<byte[]> {
        public byte[] fromBytes(byte[] bytes) {
            return bytes;
        }
    }
}

