/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.audit.AuditPrincipalIdProvider;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.audit.SurrogateAuditPrincipalIdProvider;
import org.apereo.cas.authentication.audit.SurrogateAuthenticationEligibilityAuditableExecution;
import org.apereo.cas.authentication.audit.SurrogateEligibilitySelectionAuditResourceResolver;
import org.apereo.cas.authentication.audit.SurrogateEligibilityVerificationAuditResourceResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.SurrogateAuthentication)
@AutoConfiguration
public class SurrogateAuthenticationAuditConfiguration {

    @Configuration(value="SurrogateAuthenticationAuditPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SurrogateAuthenticationAuditPlanConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"surrogateAuditTrailRecordResolutionPlanConfigurer"})
        public AuditTrailRecordResolutionPlanConfigurer surrogateAuditTrailRecordResolutionPlanConfigurer(@Qualifier(value="surrogateEligibilityVerificationAuditResourceResolver") AuditResourceResolver surrogateEligibilityVerificationAuditResourceResolver, @Qualifier(value="surrogateEligibilitySelectionAuditResourceResolver") AuditResourceResolver surrogateEligibilitySelectionAuditResourceResolver) {
            return plan -> {
                DefaultAuditActionResolver actionResolver = new DefaultAuditActionResolver("_TRIGGERED", "");
                plan.registerAuditActionResolver("SURROGATE_AUTHENTICATION_ELIGIBILITY_VERIFICATION_ACTION_RESOLVER", (AuditActionResolver)actionResolver);
                plan.registerAuditActionResolver("SURROGATE_AUTHENTICATION_ELIGIBILITY_SELECTION_ACTION_RESOLVER", (AuditActionResolver)actionResolver);
                plan.registerAuditResourceResolver("SURROGATE_AUTHENTICATION_ELIGIBILITY_VERIFICATION_RESOURCE_RESOLVER", surrogateEligibilityVerificationAuditResourceResolver);
                plan.registerAuditResourceResolver("SURROGATE_AUTHENTICATION_ELIGIBILITY_SELECTION_RESOURCE_RESOLVER", surrogateEligibilitySelectionAuditResourceResolver);
            };
        }
    }

    @Configuration(value="SurrogateAuthenticationAuditResourcesConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SurrogateAuthenticationAuditResourcesConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"surrogateEligibilityVerificationAuditResourceResolver"})
        public AuditResourceResolver surrogateEligibilityVerificationAuditResourceResolver() {
            return new SurrogateEligibilityVerificationAuditResourceResolver();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"surrogateEligibilitySelectionAuditResourceResolver"})
        public AuditResourceResolver surrogateEligibilitySelectionAuditResourceResolver() {
            return new SurrogateEligibilitySelectionAuditResourceResolver();
        }
    }

    @Configuration(value="SurrogateAuthenticationAuditExecutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SurrogateAuthenticationAuditExecutionConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"surrogateEligibilityAuditableExecution"})
        public AuditableExecution surrogateEligibilityAuditableExecution() {
            return new SurrogateAuthenticationEligibilityAuditableExecution();
        }
    }

    @Configuration(value="SurrogateAuthenticationAuditPrincipalConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SurrogateAuthenticationAuditPrincipalConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"surrogateAuditPrincipalIdProvider"})
        public AuditPrincipalIdProvider surrogateAuditPrincipalIdProvider() {
            return new SurrogateAuditPrincipalIdProvider();
        }
    }
}

