/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.CasVersion;
import org.apereo.cas.util.InetAddressUtils;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.health.HealthComponent;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.Status;
import org.springframework.http.HttpStatus;

@Endpoint(id="status", enableByDefault=false)
@Deprecated(since="6.2.0")
public class StatusEndpoint
extends BaseCasActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusEndpoint.class);
    private final ObjectProvider<HealthEndpoint> healthEndpoint;

    public StatusEndpoint(CasConfigurationProperties casProperties, ObjectProvider<HealthEndpoint> healthEndpoint) {
        super(casProperties);
        this.healthEndpoint = healthEndpoint;
    }

    @ReadOperation
    @Operation(summary="Provides CAS server's health status", deprecated=true)
    public Map<String, Object> handle() {
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        if (this.healthEndpoint.getIfAvailable() == null) {
            model.put("status", HttpStatus.OK.value());
            model.put("description", HttpStatus.OK.name());
            LOGGER.info("Health endpoint is undefined/disabled. No health indicators may be consulted to query for health data and the status results are always going to be [{}]", model);
        } else {
            HealthComponent health = ((HealthEndpoint)this.healthEndpoint.getObject()).health();
            Status status = health.getStatus();
            if (status.equals((Object)Status.DOWN) || status.equals((Object)Status.OUT_OF_SERVICE)) {
                model.put("status", HttpStatus.SERVICE_UNAVAILABLE.value());
                model.put("description", HttpStatus.SERVICE_UNAVAILABLE.name());
            } else {
                model.put("status", HttpStatus.OK.value());
                model.put("description", HttpStatus.OK.name());
            }
            model.put("health", status.getCode());
        }
        String hostname = this.casProperties.getHost().getName();
        model.put("host", StringUtils.isBlank((CharSequence)hostname) ? InetAddressUtils.getCasServerHostName() : hostname);
        model.put("server", this.casProperties.getServer().getName());
        model.put("version", CasVersion.asString());
        return model;
    }
}

