/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.dynareg;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequest;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationResponse;
import org.apereo.cas.oidc.web.controllers.BaseOidcController;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcClientRegistrationRequestTranslator;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcClientRegistrationUtils;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class OidcClientConfigurationEndpointController
extends BaseOidcController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcClientConfigurationEndpointController.class);

    public OidcClientConfigurationEndpointController(OidcConfigurationContext configurationContext) {
        super(configurationContext);
    }

    @GetMapping(value={"/oidc/clientConfig", "/**/clientConfig"}, produces={"application/json"})
    public ResponseEntity handleRequestInternal(@RequestParam(name="client_id") String clientId, HttpServletRequest request, HttpServletResponse response) {
        JEEContext webContext = new JEEContext(request, response);
        if (!((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, "clientConfig")) {
            String body = OAuth20Utils.toJson((Object)OAuth20Utils.getErrorResponseBody((String)"invalid_request", (String)"Invalid issuer"));
            return new ResponseEntity((Object)body, HttpStatus.BAD_REQUEST);
        }
        OAuthRegisteredService service = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)((OidcConfigurationContext)this.getConfigurationContext()).getServicesManager(), (String)clientId);
        if (service instanceof OidcRegisteredService) {
            String prefix = ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getServer().getPrefix();
            OidcClientRegistrationResponse regResponse = OidcClientRegistrationUtils.getClientRegistrationResponse((OidcRegisteredService)service, prefix);
            return new ResponseEntity((Object)regResponse, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    @PatchMapping(value={"/oidc/clientConfig", "/**/clientConfig"}, produces={"application/json"})
    public ResponseEntity handleUpdates(@RequestParam(name="client_id") String clientId, @RequestBody(required=false) String jsonInput, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JEEContext webContext = new JEEContext(request, response);
        if (!((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, "clientConfig")) {
            String body = OAuth20Utils.toJson((Object)OAuth20Utils.getErrorResponseBody((String)"invalid_request", (String)"Invalid issuer"));
            return new ResponseEntity((Object)body, HttpStatus.BAD_REQUEST);
        }
        OidcRegisteredService service = (OidcRegisteredService)OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)((OidcConfigurationContext)this.getConfigurationContext()).getServicesManager(), (String)clientId);
        if (service != null) {
            long clientSecretExp;
            if (StringUtils.isNotBlank((CharSequence)jsonInput)) {
                OidcClientRegistrationRequest registrationRequest = (OidcClientRegistrationRequest)((OidcConfigurationContext)this.getConfigurationContext()).getClientRegistrationRequestSerializer().from(jsonInput);
                LOGGER.debug("Received client registration request [{}]", (Object)registrationRequest);
                service = new OidcClientRegistrationRequestTranslator((OidcConfigurationContext)this.getConfigurationContext()).translate(registrationRequest, Optional.of(service));
            }
            if ((clientSecretExp = Beans.newDuration((String)((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getOidc().getRegistration().getClientSecretExpiration()).toSeconds()) > 0L && ((OidcConfigurationContext)this.getConfigurationContext()).getClientSecretValidator().isClientSecretExpired((OAuthRegisteredService)service)) {
                ZonedDateTime currentTime = ZonedDateTime.now(ZoneOffset.UTC);
                ZonedDateTime expirationDate = currentTime.plusSeconds(clientSecretExp);
                service.setClientSecretExpiration(expirationDate.toEpochSecond());
                service.setClientSecret(((OidcConfigurationContext)this.getConfigurationContext()).getClientSecretGenerator().getNewString());
                LOGGER.debug("Client secret shall expire at [{}] while now is [{}]", (Object)expirationDate, (Object)currentTime);
            }
            OidcClientRegistrationResponse clientResponse = OidcClientRegistrationUtils.getClientRegistrationResponse(service, ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getServer().getPrefix());
            return new ResponseEntity((Object)clientResponse, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }
}

