/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.accordion;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryGenericPanel;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.widget.accordion.AccordionBehavior;
import com.googlecode.wicket.kendo.ui.widget.accordion.IAccordionListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class AccordionPanel
extends JQueryGenericPanel<List<ITab>>
implements IAccordionListener {
    private static final long serialVersionUID = 1L;
    private AccordionBehavior widgetBehavior;

    public AccordionPanel(String id, List<ITab> tabs) {
        this(id, (IModel<List<ITab>>)Model.ofList(tabs), new Options());
    }

    public AccordionPanel(String id, List<ITab> tabs, Options options) {
        this(id, (IModel<List<ITab>>)Model.ofList(tabs), options);
    }

    public AccordionPanel(String id, IModel<List<ITab>> model) {
        this(id, model, new Options());
    }

    public AccordionPanel(String id, IModel<List<ITab>> model, Options options) {
        super(id, model, options);
    }

    public String getSelector() {
        return this.widgetBehavior.getSelector();
    }

    public List<ITab> getModelObject() {
        List list = (List)super.getModelObject();
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    private Model<Integer> getCountModel() {
        return new Model<Integer>(){
            private static final long serialVersionUID = 1L;

            public Integer getObject() {
                return AccordionPanel.this.getModelObject().size();
            }
        };
    }

    public AccordionPanel setTabIndex(int index) {
        this.widgetBehavior.tabIndex = index;
        return this;
    }

    public void setTabIndex(int index, IPartialPageRequestHandler handler) {
        this.widgetBehavior.select(index, handler);
    }

    public int getLastTabIndex() {
        int index = -1;
        Iterator iterator = this.getModelObject().iterator();
        while (iterator.hasNext()) {
            ITab tab = (ITab)iterator.next();
            if (!tab.isVisible()) continue;
            ++index;
        }
        return index;
    }

    @Override
    public boolean isSelectEventEnabled() {
        return true;
    }

    @Override
    public boolean isActivateEventEnabled() {
        return false;
    }

    @Override
    public boolean isExpandEventEnabled() {
        return false;
    }

    @Override
    public boolean isCollapseEventEnabled() {
        return false;
    }

    protected void onInitialize() {
        super.onInitialize();
        WebMarkupContainer root = new WebMarkupContainer("root");
        this.add(new Component[]{root});
        root.add(new Component[]{new Loop("tabs", (IModel)this.getCountModel()){
            private static final long serialVersionUID = 1L;

            protected LoopItem newItem(int index) {
                ITab tab = (ITab)AccordionPanel.this.getModelObject().get(index);
                LoopItem item = super.newItem(index);
                item.setVisible(tab.isVisible());
                return item;
            }

            protected void populateItem(LoopItem item) {
                int index = item.getIndex();
                ITab tab = (ITab)AccordionPanel.this.getModelObject().get(index);
                item.add(new Component[]{AccordionPanel.this.newTitleLabel("title", (IModel<String>)tab.getTitle())});
                item.add(new Component[]{tab.getPanel("panel")});
            }
        }});
        this.widgetBehavior = (AccordionBehavior)IJQueryWidget.JQueryWidget.newWidgetBehavior((IJQueryWidget)this, (Component)root);
        this.add(new Behavior[]{this.widgetBehavior});
    }

    @Override
    public void onSelect(AjaxRequestTarget target, int index, ITab tab) {
    }

    @Override
    public void onActivate(AjaxRequestTarget target, int index, ITab tab) {
    }

    @Override
    public void onExpand(AjaxRequestTarget target, int index, ITab tab) {
    }

    @Override
    public void onCollapse(AjaxRequestTarget target, int index, ITab tab) {
    }

    protected Component newTitleLabel(String id, IModel<String> title) {
        return new Label(id, title);
    }

    public AccordionBehavior newWidgetBehavior(String selector) {
        return new AccordionBehavior(selector, this.options, this){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<ITab> getTabs() {
                return AccordionPanel.this.getModelObject();
            }
        };
    }
}

