/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.panels.OIDCProvidersDirectoryPanel;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.OIDCProviderRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.console.wizards.mapping.ItemTransformersTogglePanel;
import org.apache.syncope.client.console.wizards.mapping.JEXLTransformersTogglePanel;
import org.apache.syncope.client.console.wizards.mapping.OIDCProviderMappingPanel;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizardBuilder;
import org.apache.syncope.common.lib.OIDCScopeConstants;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.to.OIDCC4UIProviderTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.UrlValidator;

public class OIDCProviderWizardBuilder
extends AjaxWizardBuilder<OIDCC4UIProviderTO> {
    private static final long serialVersionUID = -3310772400714122768L;
    protected final OIDCProvidersDirectoryPanel directoryPanel;
    protected final ImplementationRestClient implementationRestClient;
    protected final OIDCProviderRestClient oidcProviderRestClient;
    protected final IModel<List<String>> opActions = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return OIDCProviderWizardBuilder.this.implementationRestClient.list("OP_ACTIONS").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
        }
    };

    public OIDCProviderWizardBuilder(OIDCProvidersDirectoryPanel directoryPanel, OIDCC4UIProviderTO defaultItem, ImplementationRestClient implementationRestClient, OIDCProviderRestClient oidcProviderRestClient, PageReference pageRef) {
        super((Serializable)defaultItem, pageRef);
        this.directoryPanel = directoryPanel;
        this.implementationRestClient = implementationRestClient;
        this.oidcProviderRestClient = oidcProviderRestClient;
    }

    protected Serializable onApplyInternal(OIDCC4UIProviderTO modelObject) {
        if (modelObject.getKey() == null) {
            if (modelObject.getHasDiscovery()) {
                this.oidcProviderRestClient.createFromDiscovery(modelObject);
            } else {
                this.oidcProviderRestClient.create(modelObject);
            }
        } else {
            this.oidcProviderRestClient.update(modelObject);
        }
        return modelObject;
    }

    protected WizardModel buildModelSteps(OIDCC4UIProviderTO modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new OP(modelObject));
        wizardModel.add((IWizardStep)new OPContinue(modelObject, modelObject.getKey() != null));
        Mapping mapping = new Mapping();
        mapping.setOutputMarkupId(true);
        ItemTransformersTogglePanel mapItemTransformers = new ItemTransformersTogglePanel((WebMarkupContainer)mapping, this.pageRef);
        this.addOuterObject(new Component[]{mapItemTransformers});
        JEXLTransformersTogglePanel jexlTransformers = new JEXLTransformersTogglePanel((WebMarkupContainer)mapping, this.pageRef);
        this.addOuterObject(new Component[]{jexlTransformers});
        mapping.add(new Component[]{new OIDCProviderMappingPanel("mapping", modelObject, mapItemTransformers, jexlTransformers)});
        wizardModel.add((IWizardStep)mapping);
        return wizardModel;
    }

    protected long getMaxWaitTimeInSeconds() {
        return SyncopeWebApplication.get().getMaxWaitTimeInSeconds();
    }

    protected void sendError(Exception exception) {
        SyncopeConsoleSession.get().onException(exception);
    }

    protected void sendWarning(String message) {
        SyncopeConsoleSession.get().warn((Serializable)((Object)message));
    }

    protected Future<Pair<Serializable, Serializable>> execute(Callable<Pair<Serializable, Serializable>> future) {
        return SyncopeConsoleSession.get().execute(future);
    }

    private static void showHide(AjaxCheckBoxPanel hasDiscovery, WebMarkupContainer visibleParams) {
        visibleParams.setVisible("false".equals(hasDiscovery.getField().getValue()));
    }

    private static final class Mapping
    extends WizardStep {
        private static final long serialVersionUID = 3454904947720856253L;

        Mapping() {
            this.setTitleModel((IModel)Model.of((Serializable)((Object)"Mapping")));
            this.setSummaryModel((IModel)Model.of((Serializable)((Object)"")));
        }
    }

    public static class OPContinue
    extends WizardStep {
        private static final long serialVersionUID = -7087008312629522790L;

        public OPContinue(OIDCC4UIProviderTO opTO, boolean readOnly) {
            this.setOutputMarkupId(true);
            WebMarkupContainer content = new WebMarkupContainer("content");
            content.setOutputMarkupId(true);
            this.add(new Component[]{content});
            UrlValidator urlValidator = new UrlValidator();
            AjaxTextFieldPanel issuer = new AjaxTextFieldPanel("issuer", "issuer", (IModel)new PropertyModel((Object)opTO, "issuer"));
            issuer.addValidator((IValidator)urlValidator);
            issuer.addRequiredLabel();
            content.add(new Component[]{issuer.setReadOnly(readOnly)});
            final AjaxCheckBoxPanel hasDiscovery = new AjaxCheckBoxPanel("hasDiscovery", "hasDiscovery", (IModel)new PropertyModel((Object)opTO, "hasDiscovery"));
            content.add(new Component[]{hasDiscovery});
            AjaxTextFieldPanel authorizationEndpoint = new AjaxTextFieldPanel("authorizationEndpoint", "authorizationEndpoint", (IModel)new PropertyModel((Object)opTO, "authorizationEndpoint"));
            authorizationEndpoint.addRequiredLabel();
            authorizationEndpoint.addValidator((IValidator)urlValidator);
            content.add(new Component[]{authorizationEndpoint.setReadOnly(readOnly)});
            AjaxTextFieldPanel userinfoEndpoint = new AjaxTextFieldPanel("userinfoEndpoint", "userinfoEndpoint", (IModel)new PropertyModel((Object)opTO, "userinfoEndpoint"));
            userinfoEndpoint.addValidator((IValidator)urlValidator);
            content.add(new Component[]{userinfoEndpoint.setReadOnly(readOnly)});
            AjaxTextFieldPanel tokenEndpoint = new AjaxTextFieldPanel("tokenEndpoint", "tokenEndpoint", (IModel)new PropertyModel((Object)opTO, "tokenEndpoint"));
            tokenEndpoint.addRequiredLabel();
            tokenEndpoint.addValidator((IValidator)urlValidator);
            content.add(new Component[]{tokenEndpoint.setReadOnly(readOnly)});
            AjaxTextFieldPanel jwksUri = new AjaxTextFieldPanel("jwksUri", "jwksUri", (IModel)new PropertyModel((Object)opTO, "jwksUri"));
            jwksUri.addRequiredLabel();
            jwksUri.addValidator((IValidator)urlValidator);
            content.add(new Component[]{jwksUri.setReadOnly(readOnly)});
            AjaxTextFieldPanel endSessionEndpoint = new AjaxTextFieldPanel("endSessionEndpoint", "endSessionEndpoint", (IModel)new PropertyModel((Object)opTO, "endSessionEndpoint"));
            endSessionEndpoint.addValidator((IValidator)urlValidator);
            content.add(new Component[]{endSessionEndpoint.setReadOnly(readOnly)});
            final WebMarkupContainer visibleParams = new WebMarkupContainer("visibleParams");
            visibleParams.setOutputMarkupPlaceholderTag(true);
            visibleParams.add(new Component[]{authorizationEndpoint});
            visibleParams.add(new Component[]{userinfoEndpoint});
            visibleParams.add(new Component[]{tokenEndpoint});
            visibleParams.add(new Component[]{jwksUri});
            visibleParams.add(new Component[]{endSessionEndpoint});
            content.add(new Component[]{visibleParams});
            OIDCProviderWizardBuilder.showHide(hasDiscovery, visibleParams);
            hasDiscovery.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    OIDCProviderWizardBuilder.showHide(hasDiscovery, visibleParams);
                    target.add(new Component[]{visibleParams});
                }
            }});
            AjaxTextFieldPanel value = new AjaxTextFieldPanel("panel", "scopes", (IModel)new Model());
            value.setChoices(OIDCScopeConstants.ALL_STANDARD_SCOPES);
            content.add(new Component[]{new MultiFieldPanel.Builder((IModel)new PropertyModel((Object)opTO, "scopes")).build("scopes", "scopes", (FieldPanel)value)});
        }
    }

    public class OP
    extends WizardStep {
        private static final long serialVersionUID = 7127421283216134900L;

        public OP(OIDCC4UIProviderTO opTO) {
            AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", "name", (IModel)new PropertyModel((Object)opTO, "name"), false);
            name.addRequiredLabel();
            name.setEnabled(true);
            this.add(new Component[]{name});
            AjaxTextFieldPanel clientID = new AjaxTextFieldPanel("clientID", "clientID", (IModel)new PropertyModel((Object)opTO, "clientID"), false);
            clientID.addRequiredLabel();
            clientID.setEnabled(true);
            this.add(new Component[]{clientID});
            AjaxTextFieldPanel clientSecret = new AjaxTextFieldPanel("clientSecret", "clientSecret", (IModel)new PropertyModel((Object)opTO, "clientSecret"), false);
            clientSecret.addRequiredLabel();
            clientSecret.setEnabled(true);
            this.add(new Component[]{clientSecret});
            AjaxCheckBoxPanel createUnmatching = new AjaxCheckBoxPanel("createUnmatching", "createUnmatching", (IModel)new PropertyModel((Object)opTO, "createUnmatching"), false);
            this.add(new Component[]{createUnmatching});
            AjaxCheckBoxPanel selfRegUnmatching = new AjaxCheckBoxPanel("selfRegUnmatching", "selfRegUnmatching", (IModel)new PropertyModel((Object)opTO, "selfRegUnmatching"), false);
            this.add(new Component[]{selfRegUnmatching});
            AjaxCheckBoxPanel updateMatching = new AjaxCheckBoxPanel("updateMatching", "updateMatching", (IModel)new PropertyModel((Object)opTO, "updateMatching"), false);
            this.add(new Component[]{updateMatching});
            AjaxPalettePanel actions = new AjaxPalettePanel.Builder().setName(new StringResourceModel("actions", (Component)OIDCProviderWizardBuilder.this.directoryPanel).getString()).setAllowMoveAll(true).setAllowOrder(true).build("actions", (IModel)new PropertyModel((Object)opTO, "actions"), (IModel)new ListModel((List)OIDCProviderWizardBuilder.this.opActions.getObject()));
            actions.setOutputMarkupId(true);
            this.add(new Component[]{actions});
        }
    }
}

