/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import java.util.List;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractMultifactorAuthenticationAction<T extends MultifactorAuthenticationProvider>
extends BaseCasWebflowAction {
    protected transient T provider;

    protected Event doPreExecute(RequestContext requestContext) throws Exception {
        String providerId = WebUtils.getMultifactorAuthenticationProviderById((RequestContext)requestContext);
        ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
        this.provider = (MultifactorAuthenticationProvider)MultifactorAuthenticationUtils.getMultifactorAuthenticationProviderById((String)providerId, (ApplicationContext)applicationContext).orElseThrow(() -> new AuthenticationException("Unable to determine multifactor authentication provider for " + providerId));
        return super.doPreExecute(requestContext);
    }

    protected Principal resolvePrincipal(Principal principal) {
        List resolvers = ApplicationContextProvider.getMultifactorAuthenticationPrincipalResolvers();
        return resolvers.stream().filter(resolver -> resolver.supports(principal)).findFirst().map(r -> r.resolve(principal)).orElseThrow(() -> new IllegalStateException("Unable to resolve principal for multifactor authentication"));
    }
}

