/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.modal;

import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.TrapFocusBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;

public class ModalDialog
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String OVERLAY_ID = "overlay";
    private static final String DIALOG_ID = "dialog";
    public static final String CONTENT_ID = "content";
    private final WebMarkupContainer overlay;
    private final WebMarkupContainer dialog;
    private boolean removeContentOnClose;

    public ModalDialog(String id) {
        super(id);
        this.setOutputMarkupId(true);
        this.overlay = this.newOverlay(OVERLAY_ID);
        this.overlay.setVisible(false);
        this.add(new Component[]{this.overlay});
        this.dialog = this.newDialog(DIALOG_ID);
        this.overlay.add(new Component[]{this.dialog});
    }

    protected WebMarkupContainer newOverlay(String overlayId) {
        return new WebMarkupContainer(overlayId);
    }

    protected WebMarkupContainer newDialog(String dialogId) {
        return new WebMarkupContainer(dialogId);
    }

    public void setContent(Component content) {
        if (!CONTENT_ID.equals(content.getId())) {
            throw new IllegalArgumentException("Content must have wicket id set to ModalDialog.CONTENT_ID");
        }
        this.dialog.addOrReplace(new Component[]{content});
        this.removeContentOnClose = false;
    }

    public ModalDialog open(Component content, AjaxRequestTarget target) {
        this.setContent(content);
        this.removeContentOnClose = true;
        this.overlay.setVisible(true);
        if (target != null) {
            target.add(new Component[]{this});
        }
        return this;
    }

    public ModalDialog open(AjaxRequestTarget target) {
        if (this.overlay.size() == 0) {
            throw new WicketRuntimeException(String.format("ModalDialog with id '%s' has no content set!", this.getId()));
        }
        this.overlay.setVisible(true);
        if (target != null) {
            target.add(new Component[]{this});
        }
        return this;
    }

    public boolean isOpen() {
        return this.overlay.isVisible();
    }

    public ModalDialog close(AjaxRequestTarget target) {
        this.overlay.setVisible(false);
        if (this.removeContentOnClose) {
            this.dialog.removeAll();
        }
        if (target != null) {
            target.add(new Component[]{this});
        }
        return this;
    }

    public ModalDialog closeOnEscape() {
        this.overlay.add(new Behavior[]{new CloseBehavior("keydown"){

            @Override
            protected CharSequence getPrecondition() {
                return "return Wicket.Event.keyCode(attrs.event) == 27";
            }
        }});
        return this;
    }

    public ModalDialog closeOnClick() {
        this.overlay.add(new Behavior[]{new CloseBehavior("click"){

            @Override
            protected CharSequence getPrecondition() {
                return String.format("return attrs.event.target.id === '%s';", ModalDialog.this.overlay.getMarkupId());
            }
        }});
        return this;
    }

    public ModalDialog trapFocus() {
        this.overlay.add(new Behavior[]{new TrapFocusBehavior()});
        return this;
    }

    private abstract class CloseBehavior
    extends AjaxEventBehavior {
        private CloseBehavior(String event) {
            super(event);
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            attributes.setEventPropagation(AjaxRequestAttributes.EventPropagation.STOP_IMMEDIATE);
            attributes.getAjaxCallListeners().add(new AjaxCallListener(){

                public CharSequence getPrecondition(Component component) {
                    return CloseBehavior.this.getPrecondition();
                }
            });
        }

        protected CharSequence getPrecondition() {
            return "";
        }

        protected void onEvent(AjaxRequestTarget target) {
            ModalDialog.this.close(target);
        }
    }
}

