/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.function.Predicate;
import org.springframework.util.Assert;

public enum ConfigurationPropertyState {
    PRESENT,
    ABSENT,
    UNKNOWN;


    static <T> ConfigurationPropertyState search(Iterable<T> source, Predicate<T> predicate) {
        Assert.notNull(source, (String)"Source must not be null");
        Assert.notNull(predicate, (String)"Predicate must not be null");
        for (T item : source) {
            if (!predicate.test(item)) continue;
            return PRESENT;
        }
        return ABSENT;
    }
}

