/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.view;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.servlet.view.UrlBasedViewResolver;
import org.springframework.webflow.context.servlet.AjaxHandler;
import org.springframework.webflow.context.servlet.DefaultAjaxHandler;

public class AjaxUrlBasedViewResolver
extends UrlBasedViewResolver {
    protected View createView(String viewName, Locale locale) throws Exception {
        if (!this.canHandle(viewName, locale)) {
            return null;
        }
        if (viewName.startsWith("redirect:")) {
            String redirectUrl = viewName.substring("redirect:".length());
            return new AjaxRedirectView(redirectUrl, this.isRedirectContextRelative(), this.isRedirectHttp10Compatible());
        }
        return super.createView(viewName, locale);
    }

    private class AjaxRedirectView
    extends RedirectView
    implements View {
        private AjaxHandler ajaxHandler;

        public AjaxRedirectView(String redirectUrl, boolean redirectContextRelative, boolean redirectHttp10Compatible) {
            super(redirectUrl, redirectContextRelative, redirectHttp10Compatible);
            this.ajaxHandler = new DefaultAjaxHandler();
        }

        protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String targetUrl, boolean http10Compatible) throws IOException {
            if (this.ajaxHandler.isAjaxRequest(request, response)) {
                this.ajaxHandler.sendAjaxRedirect(targetUrl, request, response, false);
            } else {
                super.sendRedirect(request, response, targetUrl, http10Compatible);
            }
        }
    }
}

