/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.bloodhound;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.bloodhound.Bloodhound;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.bloodhound.BloodhoundConfig;
import de.agilecoders.wicket.jquery.util.Json;
import java.util.Collections;
import java.util.List;

public class LocalBloodhound<T>
extends Bloodhound<T> {
    public LocalBloodhound(String name, BloodhoundConfig config, List<String> datasource) {
        super(name, config);
        this.initConfig(datasource);
    }

    public LocalBloodhound(String name, List<String> datasource) {
        super(name);
        this.initConfig(datasource);
    }

    private void initConfig(List<String> datasource) {
        Function createDatum = s -> String.format("{value: '%s'}", s);
        String local = "[" + Joiner.on((char)',').join((Iterable)Lists.transform(datasource, (Function)createDatum)) + "]";
        this.getConfig().withLocal(new Json.RawValue(local));
    }

    @Override
    public Iterable<T> getChoices(String input) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public String renderChoice(T choice) {
        return choice != null ? choice.toString() : "";
    }
}

