/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.serialize.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.wicket.serialize.java.JavaSerializer;

public class DeflatedJavaSerializer
extends JavaSerializer {
    private static final int COMPRESS_BUF_SIZE = 4096;

    public DeflatedJavaSerializer(String applicationKey) {
        super(applicationKey);
    }

    @Override
    protected ObjectOutputStream newObjectOutputStream(OutputStream out) throws IOException {
        return super.newObjectOutputStream(new DeflaterOutputStream(out, this.createDeflater(), 4096));
    }

    protected Deflater createDeflater() {
        return new Deflater(1);
    }

    @Override
    protected ObjectInputStream newObjectInputStream(InputStream in) throws IOException {
        return super.newObjectInputStream(new InflaterInputStream(in, new Inflater(), 4096));
    }
}

