/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management.beans.logging;

import com.tc.management.AbstractTerracottaMBean;
import com.tc.management.beans.logging.TCLoggingBroadcasterMBean;
import com.tc.management.beans.logging.TCLoggingHistoryProvider;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;

public final class TCLoggingBroadcaster
extends AbstractTerracottaMBean
implements TCLoggingBroadcasterMBean {
    private static final String LOGGING_EVENT_TYPE = "tc.logging.event";
    private static final MBeanNotificationInfo[] NOTIFICATION_INFO;
    private final AtomicLong sequenceNumber = new AtomicLong(0L);
    private final TCLoggingHistoryProvider tcLoggingHistoryProvider = new TCLoggingHistoryProvider();

    @Override
    public void reset() {
    }

    public TCLoggingBroadcaster() throws NotCompliantMBeanException {
        super(TCLoggingBroadcasterMBean.class, true);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return NOTIFICATION_INFO;
    }

    public void broadcastLogEvent(String event, String[] throwableStringRep) {
        Notification notif = new Notification(LOGGING_EVENT_TYPE, this, this.sequenceNumber.incrementAndGet(), System.currentTimeMillis(), event);
        notif.setUserData(throwableStringRep);
        this.sendNotification(notif);
        notif = new Notification(notif.getType(), this.getClass().getName(), notif.getSequenceNumber(), notif.getTimeStamp(), notif.getMessage());
        notif.setUserData(throwableStringRep);
        this.tcLoggingHistoryProvider.push(notif);
    }

    @Override
    public List<Notification> getLogNotifications() {
        return this.tcLoggingHistoryProvider.getLogNotifications();
    }

    @Override
    public List<Notification> getLogNotificationsSince(long timestamp) {
        return this.tcLoggingHistoryProvider.getLogNotificationsSince(timestamp);
    }

    static {
        String[] notifTypes = new String[]{LOGGING_EVENT_TYPE};
        String name = Notification.class.getName();
        String description = "Each notification sent contains a Terracotta logging event";
        NOTIFICATION_INFO = new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypes, name, "Each notification sent contains a Terracotta logging event")};
    }
}

