/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service.wa;

import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.syncope.common.lib.wa.WebAuthnAccount;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="WA")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="wa/webauthn")
public interface WebAuthnRegistrationService
extends JAXRSService {
    @GET
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<WebAuthnAccount> list();

    @GET
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Path(value="{owner}")
    public WebAuthnAccount read(@NotNull @PathParam(value="owner") String var1);

    @DELETE
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Path(value="{owner}")
    public void delete(@NotNull @PathParam(value="owner") String var1);

    @DELETE
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Path(value="{owner}/{credentialId}")
    public void delete(@NotNull @PathParam(value="owner") String var1, @NotNull @PathParam(value="credentialId") String var2);

    @POST
    @Path(value="{owner}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void create(@NotNull @PathParam(value="owner") String var1, @NotNull WebAuthnAccount var2);

    @PUT
    @Path(value="{owner}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void update(@NotNull @PathParam(value="owner") String var1, @NotNull WebAuthnAccount var2);
}

