/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.async.json.transformer.AbstractNeedsTaskHistoryJsonTransformer;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskPropertyChangedHistoryJsonTransformer
extends AbstractNeedsTaskHistoryJsonTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskPropertyChangedHistoryJsonTransformer.class);

    public TaskPropertyChangedHistoryJsonTransformer(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public List<String> getTypes() {
        return Collections.singletonList("task-property-changed");
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String taskId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"id");
        if (StringUtils.isNotEmpty((CharSequence)taskId)) {
            HistoricTaskInstanceEntity historicTaskInstance = this.processEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService().getHistoricTask(taskId);
            Date lastUpdateTime = AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"__timeStamp");
            if (historicTaskInstance.getLastUpdateTime() == null || !historicTaskInstance.getLastUpdateTime().after(lastUpdateTime)) {
                historicTaskInstance.setName(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"name"));
                historicTaskInstance.setDescription(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"description"));
                historicTaskInstance.setAssignee(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"assignee"));
                historicTaskInstance.setOwner(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"owner"));
                historicTaskInstance.setClaimTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"claimTime"));
                historicTaskInstance.setDueDate(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"dueDate"));
                historicTaskInstance.setPriority(AsyncHistoryJsonUtil.getIntegerFromJson((ObjectNode)historicalData, (String)"priority").intValue());
                historicTaskInstance.setCategory(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"category"));
                historicTaskInstance.setFormKey(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"formKey"));
                historicTaskInstance.setParentTaskId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"parentTaskId"));
                historicTaskInstance.setTaskDefinitionKey(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"taskDefinitionKey"));
                historicTaskInstance.setTaskDefinitionId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"taskDefinitionId"));
                historicTaskInstance.setProcessDefinitionId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processDefinitionId"));
                historicTaskInstance.setLastUpdateTime(lastUpdateTime);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("History job (id={}) has expired and will be ignored.", (Object)job.getId());
            }
        }
    }
}

