/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.serializer.xml;

import java.io.Writer;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.serializer.XmlObjectSerializer;
import org.identityconnectors.framework.impl.serializer.xml.XmlObjectEncoder;

public class XmlObjectSerializerImpl
implements XmlObjectSerializer {
    public static final String MULTI_OBJECT_ELEMENT = "MultiObject";
    public static final String CONNECTORS_DTD = "connectors.dtd";
    private final Writer output;
    private final boolean multiObject;
    private final boolean includeHeader;
    private boolean firstObjectWritten;
    private boolean documentEnded;

    public XmlObjectSerializerImpl(Writer output, boolean includeHeader, boolean multiObject) {
        this.output = output;
        this.includeHeader = includeHeader;
        this.multiObject = multiObject;
    }

    public void writeObject(Object object) {
        if (this.documentEnded) {
            throw new IllegalStateException("Attempt to writeObject after the document is already closed");
        }
        StringBuilder buf = new StringBuilder();
        XmlObjectEncoder encoder = new XmlObjectEncoder(buf);
        String elementName = encoder.writeObject(object);
        if (!this.firstObjectWritten) {
            this.startDocument(elementName);
        } else if (!this.multiObject) {
            throw new IllegalStateException("Attempt to write multiple objects on a single-object document");
        }
        this.write(buf.toString());
        this.firstObjectWritten = true;
    }

    public void flush() {
        try {
            this.output.flush();
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public void close(boolean closeStream) {
        if (!this.documentEnded) {
            if (!this.firstObjectWritten) {
                if (!this.multiObject) {
                    throw new IllegalStateException("Attempt to write zero objects on a single-object document");
                }
                this.startDocument(null);
            }
            if (this.multiObject) {
                this.write("</MultiObject>\n");
            }
            this.documentEnded = true;
        }
        if (closeStream) {
            try {
                this.output.close();
            }
            catch (Exception e) {
                throw ConnectorException.wrap((Throwable)e);
            }
        }
    }

    private void startDocument(String firstElement) {
        if (this.includeHeader) {
            this.write("<?xml version='1.0' encoding='UTF-8'?>\n");
            String docType = this.multiObject ? MULTI_OBJECT_ELEMENT : firstElement;
            this.write("<!DOCTYPE " + docType + " PUBLIC '" + CONNECTORS_DTD + "' '" + CONNECTORS_DTD + "'>\n");
        }
        if (this.multiObject) {
            this.write("<MultiObject>\n");
        }
    }

    private void write(String str) {
        try {
            this.output.write(str);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }
}

