/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl.helper;

import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;

public class CachingMap<T>
extends LinkedHashMap<String, SoftReference<T>> {
    private static final long serialVersionUID = -3392702301736494889L;
    private int capacity;

    public CachingMap(int capacity) {
        this.capacity = capacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, SoftReference<T>> eldest) {
        return this.size() > this.capacity;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.capacity;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CachingMap other = (CachingMap)obj;
        return this.capacity != other.capacity;
    }
}

