/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;
import org.osgi.framework.Version;

public class CheckBundleUnversionedPackages
implements AnalyserTask {
    private static final List<String> IGNORED_IMPORT_PREFIXES = Arrays.asList("java.", "javax.", "org.w3c.", "org.xml.");

    @Override
    public String getName() {
        return "Bundle Unversioned Packages Check";
    }

    @Override
    public String getId() {
        return "bundle-unversioned-packages";
    }

    private boolean ignoreImportPackage(String name) {
        for (String prefix : IGNORED_IMPORT_PREFIXES) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void execute(AnalyserTaskContext ctx) throws Exception {
        for (BundleDescriptor info : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            ArrayList<PackageInfo> exportWithoutVersion = new ArrayList<PackageInfo>();
            for (PackageInfo packageInfo : info.getExportedPackages()) {
                if (packageInfo.getPackageVersion().compareTo(Version.emptyVersion) != 0) continue;
                exportWithoutVersion.add(packageInfo);
            }
            ArrayList<PackageInfo> importWithoutVersion = new ArrayList<PackageInfo>();
            for (PackageInfo i3 : info.getImportedPackages()) {
                if (i3.getVersion() != null || this.ignoreImportPackage(i3.getName())) continue;
                importWithoutVersion.add(i3);
            }
            String string = "Bundle ".concat(info.getArtifact().getId().getArtifactId()).concat(":").concat(info.getArtifact().getId().getVersion());
            if (!importWithoutVersion.isEmpty()) {
                ctx.reportArtifactWarning(info.getArtifact().getId(), string.concat(" is importing ").concat(this.getPackageInfo(importWithoutVersion)).concat(" without specifying a version range."));
            }
            if (exportWithoutVersion.isEmpty()) continue;
            ctx.reportArtifactWarning(info.getArtifact().getId(), string.concat(" is exporting ").concat(this.getPackageInfo(exportWithoutVersion)).concat(" without a version."));
        }
    }

    private String getPackageInfo(List<PackageInfo> pcks) {
        if (pcks.size() == 1) {
            return "package ".concat(pcks.get(0).getName());
        }
        StringBuilder sb = new StringBuilder("packages ");
        boolean first = true;
        sb.append('[');
        for (PackageInfo info : pcks) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(info.getName());
        }
        sb.append(']');
        return sb.toString();
    }
}

