/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gts;

import jakarta.xml.bind.annotation.XmlElement;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.Duration;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.gco.PropertyType;
import org.apache.sis.xml.internal.shared.XmlUtilities;

public class TM_Duration
extends PropertyType<TM_Duration, TemporalAmount> {
    public TM_Duration() {
    }

    TM_Duration(TemporalAmount metadata) {
        super(metadata);
    }

    @Override
    protected TM_Duration wrap(TemporalAmount value) {
        return new TM_Duration(value);
    }

    @Override
    protected final Class<TemporalAmount> getBoundType() {
        return TemporalAmount.class;
    }

    final TemporalAmount get() {
        return (TemporalAmount)this.metadata;
    }

    @XmlElement(name="TM_Duration")
    public final Duration getElement() {
        TemporalAmount metadata = (TemporalAmount)this.metadata;
        if (metadata != null) {
            try {
                BigInteger years = null;
                BigInteger months = null;
                BigInteger days = null;
                BigInteger hours = null;
                BigInteger minutes = null;
                BigDecimal seconds = null;
                block13: for (TemporalUnit unit : metadata.getUnits()) {
                    if (unit instanceof ChronoUnit) {
                        BigInteger value = BigInteger.valueOf(metadata.get(unit));
                        switch ((ChronoUnit)unit) {
                            case YEARS: {
                                years = value;
                                continue block13;
                            }
                            case MONTHS: {
                                months = value;
                                continue block13;
                            }
                            case DAYS: {
                                days = value;
                                continue block13;
                            }
                            case HOURS: {
                                hours = value;
                                continue block13;
                            }
                            case MINUTES: {
                                minutes = value;
                                continue block13;
                            }
                            case SECONDS: {
                                seconds = new BigDecimal(value);
                                continue block13;
                            }
                            case MILLIS: {
                                seconds = TM_Duration.addSeconds(seconds, value, 1000);
                                continue block13;
                            }
                            case MICROS: {
                                seconds = TM_Duration.addSeconds(seconds, value, 1000000);
                                continue block13;
                            }
                            case NANOS: {
                                seconds = TM_Duration.addSeconds(seconds, value, 1000000000);
                                continue block13;
                            }
                        }
                    }
                    Context.warningOccured(Context.current(), TM_Duration.class, "getElement", Errors.class, (short)200, unit);
                    return null;
                }
                return XmlUtilities.getDatatypeFactory().newDuration(true, years, months, days, hours, minutes, seconds);
            }
            catch (DatatypeConfigurationException e) {
                Context.warningOccured(Context.current(), TM_Duration.class, "getElement", e, true);
            }
        }
        return null;
    }

    private static BigDecimal addSeconds(BigDecimal current, BigInteger numerator, int denominator) {
        if (BigInteger.ZERO.equals(numerator)) {
            return current;
        }
        BigDecimal toAdd = new BigDecimal(numerator).divide(BigDecimal.valueOf(denominator));
        return current != null ? current.add(toAdd) : toAdd;
    }

    public void setElement(Duration duration) {
        if (duration != null) {
            int days;
            int months;
            int years = duration.getYears();
            if ((years | (months = duration.getMonths()) | (days = duration.getDays())) != 0) {
                this.metadata = Period.of(years, months, days);
            } else {
                int seconds;
                int minutes;
                int hours = duration.getHours();
                if ((hours | (minutes = duration.getMinutes()) | (seconds = duration.getSeconds())) != 0) {
                    this.metadata = java.time.Duration.ofSeconds(((long)hours * 24L + (long)minutes) * 60L + (long)seconds);
                }
            }
        }
    }

    public static final class Since2014
    extends TM_Duration {
        @Override
        protected TM_Duration wrap(TemporalAmount value) {
            return this.accept2014() ? super.wrap(value) : null;
        }
    }
}

