/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum OpcuaNodeIdServicesVariableOperation {
  OperationLimitsType_MaxNodesPerRead((int) 11565L),
  OperationLimitsType_MaxNodesPerWrite((int) 11567L),
  OperationLimitsType_MaxNodesPerMethodCall((int) 11569L),
  OperationLimitsType_MaxNodesPerBrowse((int) 11570L),
  OperationLimitsType_MaxNodesPerRegisterNodes((int) 11571L),
  OperationLimitsType_MaxNodesPerTranslateBrowsePathsToNodeIds((int) 11572L),
  OperationLimitsType_MaxNodesPerNodeManagement((int) 11573L),
  OperationLimitsType_MaxMonitoredItemsPerCall((int) 11574L),
  OperationLimitsType_MaxNodesPerHistoryReadData((int) 12161L),
  OperationLimitsType_MaxNodesPerHistoryReadEvents((int) 12162L),
  OperationLimitsType_MaxNodesPerHistoryUpdateData((int) 12163L),
  OperationLimitsType_MaxNodesPerHistoryUpdateEvents((int) 12164L);
  private static final Map<Integer, OpcuaNodeIdServicesVariableOperation> map;

  static {
    map = new HashMap<>();
    for (OpcuaNodeIdServicesVariableOperation value :
        OpcuaNodeIdServicesVariableOperation.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  OpcuaNodeIdServicesVariableOperation(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static OpcuaNodeIdServicesVariableOperation enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
