/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesAccessCredentialDisable is the corresponding interface of BACnetPropertyStatesAccessCredentialDisable
type BACnetPropertyStatesAccessCredentialDisable interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPropertyStates
	// GetAccessCredentialDisable returns AccessCredentialDisable (property field)
	GetAccessCredentialDisable() BACnetAccessCredentialDisableTagged
	// IsBACnetPropertyStatesAccessCredentialDisable is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStatesAccessCredentialDisable()
	// CreateBuilder creates a BACnetPropertyStatesAccessCredentialDisableBuilder
	CreateBACnetPropertyStatesAccessCredentialDisableBuilder() BACnetPropertyStatesAccessCredentialDisableBuilder
}

// _BACnetPropertyStatesAccessCredentialDisable is the data-structure of this message
type _BACnetPropertyStatesAccessCredentialDisable struct {
	BACnetPropertyStatesContract
	AccessCredentialDisable BACnetAccessCredentialDisableTagged
}

var _ BACnetPropertyStatesAccessCredentialDisable = (*_BACnetPropertyStatesAccessCredentialDisable)(nil)
var _ BACnetPropertyStatesRequirements = (*_BACnetPropertyStatesAccessCredentialDisable)(nil)

// NewBACnetPropertyStatesAccessCredentialDisable factory function for _BACnetPropertyStatesAccessCredentialDisable
func NewBACnetPropertyStatesAccessCredentialDisable(peekedTagHeader BACnetTagHeader, accessCredentialDisable BACnetAccessCredentialDisableTagged) *_BACnetPropertyStatesAccessCredentialDisable {
	if accessCredentialDisable == nil {
		panic("accessCredentialDisable of type BACnetAccessCredentialDisableTagged for BACnetPropertyStatesAccessCredentialDisable must not be nil")
	}
	_result := &_BACnetPropertyStatesAccessCredentialDisable{
		BACnetPropertyStatesContract: NewBACnetPropertyStates(peekedTagHeader),
		AccessCredentialDisable:      accessCredentialDisable,
	}
	_result.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesAccessCredentialDisableBuilder is a builder for BACnetPropertyStatesAccessCredentialDisable
type BACnetPropertyStatesAccessCredentialDisableBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(accessCredentialDisable BACnetAccessCredentialDisableTagged) BACnetPropertyStatesAccessCredentialDisableBuilder
	// WithAccessCredentialDisable adds AccessCredentialDisable (property field)
	WithAccessCredentialDisable(BACnetAccessCredentialDisableTagged) BACnetPropertyStatesAccessCredentialDisableBuilder
	// WithAccessCredentialDisableBuilder adds AccessCredentialDisable (property field) which is build by the builder
	WithAccessCredentialDisableBuilder(func(BACnetAccessCredentialDisableTaggedBuilder) BACnetAccessCredentialDisableTaggedBuilder) BACnetPropertyStatesAccessCredentialDisableBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPropertyStatesBuilder
	// Build builds the BACnetPropertyStatesAccessCredentialDisable or returns an error if something is wrong
	Build() (BACnetPropertyStatesAccessCredentialDisable, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStatesAccessCredentialDisable
}

// NewBACnetPropertyStatesAccessCredentialDisableBuilder() creates a BACnetPropertyStatesAccessCredentialDisableBuilder
func NewBACnetPropertyStatesAccessCredentialDisableBuilder() BACnetPropertyStatesAccessCredentialDisableBuilder {
	return &_BACnetPropertyStatesAccessCredentialDisableBuilder{_BACnetPropertyStatesAccessCredentialDisable: new(_BACnetPropertyStatesAccessCredentialDisable)}
}

type _BACnetPropertyStatesAccessCredentialDisableBuilder struct {
	*_BACnetPropertyStatesAccessCredentialDisable

	parentBuilder *_BACnetPropertyStatesBuilder

	collectedErr []error
}

var _ (BACnetPropertyStatesAccessCredentialDisableBuilder) = (*_BACnetPropertyStatesAccessCredentialDisableBuilder)(nil)

func (b *_BACnetPropertyStatesAccessCredentialDisableBuilder) setParent(contract BACnetPropertyStatesContract) {
	b.BACnetPropertyStatesContract = contract
	contract.(*_BACnetPropertyStates)._SubType = b._BACnetPropertyStatesAccessCredentialDisable
}

func (b *_BACnetPropertyStatesAccessCredentialDisableBuilder) WithMandatoryFields(accessCredentialDisable BACnetAccessCredentialDisableTagged) BACnetPropertyStatesAccessCredentialDisableBuilder {
	return b.WithAccessCredentialDisable(accessCredentialDisable)
}

func (b *_BACnetPropertyStatesAccessCredentialDisableBuilder) WithAccessCredentialDisable(accessCredentialDisable BACnetAccessCredentialDisableTagged) BACnetPropertyStatesAccessCredentialDisableBuilder {
	b.AccessCredentialDisable = accessCredentialDisable
	return b
}

func (b *_BACnetPropertyStatesAccessCredentialDisableBuilder) WithAccessCredentialDisableBuilder(builderSupplier func(BACnetAccessCredentialDisableTaggedBuilder) BACnetAccessCredentialDisableTaggedBuilder) BACnetPropertyStatesAccessCredentialDisableBuilder {
	builder := builderSupplier(b.AccessCredentialDisable.CreateBACnetAccessCredentialDisableTaggedBuilder())
	var err error
	b.AccessCredentialDisable, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetAccessCredentialDisableTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesAccessCredentialDisableBuilder) Build() (BACnetPropertyStatesAccessCredentialDisable, error) {
	if b.AccessCredentialDisable == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'accessCredentialDisable' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetPropertyStatesAccessCredentialDisable.deepCopy(), nil
}

func (b *_BACnetPropertyStatesAccessCredentialDisableBuilder) MustBuild() BACnetPropertyStatesAccessCredentialDisable {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesAccessCredentialDisableBuilder) Done() BACnetPropertyStatesBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPropertyStatesBuilder().(*_BACnetPropertyStatesBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPropertyStatesAccessCredentialDisableBuilder) buildForBACnetPropertyStates() (BACnetPropertyStates, error) {
	return b.Build()
}

func (b *_BACnetPropertyStatesAccessCredentialDisableBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesAccessCredentialDisableBuilder().(*_BACnetPropertyStatesAccessCredentialDisableBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetPropertyStatesAccessCredentialDisableBuilder creates a BACnetPropertyStatesAccessCredentialDisableBuilder
func (b *_BACnetPropertyStatesAccessCredentialDisable) CreateBACnetPropertyStatesAccessCredentialDisableBuilder() BACnetPropertyStatesAccessCredentialDisableBuilder {
	if b == nil {
		return NewBACnetPropertyStatesAccessCredentialDisableBuilder()
	}
	return &_BACnetPropertyStatesAccessCredentialDisableBuilder{_BACnetPropertyStatesAccessCredentialDisable: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesAccessCredentialDisable) GetParent() BACnetPropertyStatesContract {
	return m.BACnetPropertyStatesContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesAccessCredentialDisable) GetAccessCredentialDisable() BACnetAccessCredentialDisableTagged {
	return m.AccessCredentialDisable
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesAccessCredentialDisable(structType any) BACnetPropertyStatesAccessCredentialDisable {
	if casted, ok := structType.(BACnetPropertyStatesAccessCredentialDisable); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesAccessCredentialDisable); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesAccessCredentialDisable) GetTypeName() string {
	return "BACnetPropertyStatesAccessCredentialDisable"
}

func (m *_BACnetPropertyStatesAccessCredentialDisable) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).getLengthInBits(ctx))

	// Simple field (accessCredentialDisable)
	lengthInBits += m.AccessCredentialDisable.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesAccessCredentialDisable) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPropertyStatesAccessCredentialDisable) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPropertyStates, peekedTagNumber uint8) (__bACnetPropertyStatesAccessCredentialDisable BACnetPropertyStatesAccessCredentialDisable, err error) {
	m.BACnetPropertyStatesContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesAccessCredentialDisable"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesAccessCredentialDisable")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	accessCredentialDisable, err := ReadSimpleField[BACnetAccessCredentialDisableTagged](ctx, "accessCredentialDisable", ReadComplex[BACnetAccessCredentialDisableTagged](BACnetAccessCredentialDisableTaggedParseWithBufferProducer((uint8)(peekedTagNumber), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'accessCredentialDisable' field"))
	}
	m.AccessCredentialDisable = accessCredentialDisable

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesAccessCredentialDisable"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesAccessCredentialDisable")
	}

	return m, nil
}

func (m *_BACnetPropertyStatesAccessCredentialDisable) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesAccessCredentialDisable) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesAccessCredentialDisable"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesAccessCredentialDisable")
		}

		if err := WriteSimpleField[BACnetAccessCredentialDisableTagged](ctx, "accessCredentialDisable", m.GetAccessCredentialDisable(), WriteComplex[BACnetAccessCredentialDisableTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'accessCredentialDisable' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesAccessCredentialDisable"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesAccessCredentialDisable")
		}
		return nil
	}
	return m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesAccessCredentialDisable) IsBACnetPropertyStatesAccessCredentialDisable() {
}

func (m *_BACnetPropertyStatesAccessCredentialDisable) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStatesAccessCredentialDisable) deepCopy() *_BACnetPropertyStatesAccessCredentialDisable {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesAccessCredentialDisableCopy := &_BACnetPropertyStatesAccessCredentialDisable{
		m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).deepCopy(),
		utils.DeepCopy[BACnetAccessCredentialDisableTagged](m.AccessCredentialDisable),
	}
	_BACnetPropertyStatesAccessCredentialDisableCopy.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = m
	return _BACnetPropertyStatesAccessCredentialDisableCopy
}

func (m *_BACnetPropertyStatesAccessCredentialDisable) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
