/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// AdsWriteResponse is the corresponding interface of AdsWriteResponse
type AdsWriteResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	AmsPacket
	// GetResult returns Result (property field)
	GetResult() ReturnCode
	// IsAdsWriteResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAdsWriteResponse()
	// CreateBuilder creates a AdsWriteResponseBuilder
	CreateAdsWriteResponseBuilder() AdsWriteResponseBuilder
}

// _AdsWriteResponse is the data-structure of this message
type _AdsWriteResponse struct {
	AmsPacketContract
	Result ReturnCode
}

var _ AdsWriteResponse = (*_AdsWriteResponse)(nil)
var _ AmsPacketRequirements = (*_AdsWriteResponse)(nil)

// NewAdsWriteResponse factory function for _AdsWriteResponse
func NewAdsWriteResponse(targetAmsNetId AmsNetId, targetAmsPort uint16, sourceAmsNetId AmsNetId, sourceAmsPort uint16, errorCode uint32, invokeId uint32, result ReturnCode) *_AdsWriteResponse {
	_result := &_AdsWriteResponse{
		AmsPacketContract: NewAmsPacket(targetAmsNetId, targetAmsPort, sourceAmsNetId, sourceAmsPort, errorCode, invokeId),
		Result:            result,
	}
	_result.AmsPacketContract.(*_AmsPacket)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AdsWriteResponseBuilder is a builder for AdsWriteResponse
type AdsWriteResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(result ReturnCode) AdsWriteResponseBuilder
	// WithResult adds Result (property field)
	WithResult(ReturnCode) AdsWriteResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() AmsPacketBuilder
	// Build builds the AdsWriteResponse or returns an error if something is wrong
	Build() (AdsWriteResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AdsWriteResponse
}

// NewAdsWriteResponseBuilder() creates a AdsWriteResponseBuilder
func NewAdsWriteResponseBuilder() AdsWriteResponseBuilder {
	return &_AdsWriteResponseBuilder{_AdsWriteResponse: new(_AdsWriteResponse)}
}

type _AdsWriteResponseBuilder struct {
	*_AdsWriteResponse

	parentBuilder *_AmsPacketBuilder

	collectedErr []error
}

var _ (AdsWriteResponseBuilder) = (*_AdsWriteResponseBuilder)(nil)

func (b *_AdsWriteResponseBuilder) setParent(contract AmsPacketContract) {
	b.AmsPacketContract = contract
	contract.(*_AmsPacket)._SubType = b._AdsWriteResponse
}

func (b *_AdsWriteResponseBuilder) WithMandatoryFields(result ReturnCode) AdsWriteResponseBuilder {
	return b.WithResult(result)
}

func (b *_AdsWriteResponseBuilder) WithResult(result ReturnCode) AdsWriteResponseBuilder {
	b.Result = result
	return b
}

func (b *_AdsWriteResponseBuilder) Build() (AdsWriteResponse, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._AdsWriteResponse.deepCopy(), nil
}

func (b *_AdsWriteResponseBuilder) MustBuild() AdsWriteResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AdsWriteResponseBuilder) Done() AmsPacketBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewAmsPacketBuilder().(*_AmsPacketBuilder)
	}
	return b.parentBuilder
}

func (b *_AdsWriteResponseBuilder) buildForAmsPacket() (AmsPacket, error) {
	return b.Build()
}

func (b *_AdsWriteResponseBuilder) DeepCopy() any {
	_copy := b.CreateAdsWriteResponseBuilder().(*_AdsWriteResponseBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateAdsWriteResponseBuilder creates a AdsWriteResponseBuilder
func (b *_AdsWriteResponse) CreateAdsWriteResponseBuilder() AdsWriteResponseBuilder {
	if b == nil {
		return NewAdsWriteResponseBuilder()
	}
	return &_AdsWriteResponseBuilder{_AdsWriteResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_AdsWriteResponse) GetCommandId() CommandId {
	return CommandId_ADS_WRITE
}

func (m *_AdsWriteResponse) GetResponse() bool {
	return bool(true)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AdsWriteResponse) GetParent() AmsPacketContract {
	return m.AmsPacketContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AdsWriteResponse) GetResult() ReturnCode {
	return m.Result
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastAdsWriteResponse(structType any) AdsWriteResponse {
	if casted, ok := structType.(AdsWriteResponse); ok {
		return casted
	}
	if casted, ok := structType.(*AdsWriteResponse); ok {
		return *casted
	}
	return nil
}

func (m *_AdsWriteResponse) GetTypeName() string {
	return "AdsWriteResponse"
}

func (m *_AdsWriteResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.AmsPacketContract.(*_AmsPacket).getLengthInBits(ctx))

	// Simple field (result)
	lengthInBits += 32

	return lengthInBits
}

func (m *_AdsWriteResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_AdsWriteResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_AmsPacket) (__adsWriteResponse AdsWriteResponse, err error) {
	m.AmsPacketContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AdsWriteResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AdsWriteResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	result, err := ReadEnumField[ReturnCode](ctx, "result", "ReturnCode", ReadEnum(ReturnCodeByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'result' field"))
	}
	m.Result = result

	if closeErr := readBuffer.CloseContext("AdsWriteResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AdsWriteResponse")
	}

	return m, nil
}

func (m *_AdsWriteResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AdsWriteResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AdsWriteResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AdsWriteResponse")
		}

		if err := WriteSimpleEnumField[ReturnCode](ctx, "result", "ReturnCode", m.GetResult(), WriteEnum[ReturnCode, uint32](ReturnCode.GetValue, ReturnCode.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'result' field")
		}

		if popErr := writeBuffer.PopContext("AdsWriteResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AdsWriteResponse")
		}
		return nil
	}
	return m.AmsPacketContract.(*_AmsPacket).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_AdsWriteResponse) IsAdsWriteResponse() {}

func (m *_AdsWriteResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AdsWriteResponse) deepCopy() *_AdsWriteResponse {
	if m == nil {
		return nil
	}
	_AdsWriteResponseCopy := &_AdsWriteResponse{
		m.AmsPacketContract.(*_AmsPacket).deepCopy(),
		m.Result,
	}
	_AdsWriteResponseCopy.AmsPacketContract.(*_AmsPacket)._SubType = m
	return _AdsWriteResponseCopy
}

func (m *_AdsWriteResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
