/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web.aot;

import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.data.web.PagedModel;
import org.springframework.data.web.config.EnableSpringDataWebSupport;
import org.springframework.data.web.config.SpringDataJackson3Configuration;
import org.springframework.data.web.config.SpringDataJacksonConfiguration;
import org.springframework.data.web.config.SpringDataWebSettings;
import org.springframework.util.ClassUtils;

class WebRuntimeHints
implements RuntimeHintsRegistrar {
    private static final boolean JACKSON2_PRESENT = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)WebRuntimeHints.class.getClassLoader());
    private static final boolean JACKSON3_PRESENT = ClassUtils.isPresent((String)"tools.jackson.databind.ObjectMapper", (ClassLoader)WebRuntimeHints.class.getClassLoader());

    WebRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        hints.reflection().registerType(SpringDataWebSettings.class, hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS}).onReachableType(EnableSpringDataWebSupport.class));
        if (JACKSON2_PRESENT || JACKSON3_PRESENT) {
            hints.reflection().registerType(PagedModel.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS});
            hints.reflection().registerType(PagedModel.PageMetadata.class, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS});
            hints.reflection().registerType(TypeReference.of((String)"org.springframework.data.domain.Unpaged"), new MemberCategory[0]);
            if (JACKSON2_PRESENT) {
                WebRuntimeHints.contributeJackson2Hints(hints);
            }
            if (JACKSON3_PRESENT) {
                WebRuntimeHints.contributeJackson3Hints(hints);
            }
        }
    }

    private static void contributeJackson2Hints(RuntimeHints hints) {
        hints.reflection().registerType(TypeReference.of((String)"org.springframework.data.web.config.SpringDataJacksonConfiguration$PageModule$PageModelConverter"), hint -> {
            hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS});
            hint.onReachableType(SpringDataJacksonConfiguration.PageModule.class);
        });
        hints.reflection().registerType(TypeReference.of((String)"org.springframework.data.web.config.SpringDataJacksonConfiguration$PageModule$PlainPageSerializationWarning"), hint -> {
            hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS});
            hint.onReachableType(SpringDataJacksonConfiguration.PageModule.class);
        });
    }

    private static void contributeJackson3Hints(RuntimeHints hints) {
        hints.reflection().registerType(TypeReference.of((String)"org.springframework.data.web.config.SpringDataJackson3Configuration$PageModule$PageModelConverter"), hint -> {
            hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS});
            hint.onReachableType(SpringDataJackson3Configuration.PageModule.class);
        });
        hints.reflection().registerType(TypeReference.of((String)"org.springframework.data.web.config.SpringDataJackson3Configuration$PageModule$PlainPageSerializationWarning"), hint -> {
            hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS});
            hint.onReachableType(SpringDataJackson3Configuration.PageModule.class);
        });
    }
}

