/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema;

import java.util.Map;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchema;
import org.apache.nifi.minifi.toolkit.schema.common.WritableSchema;

public class SensitivePropsSchema
extends BaseSchema
implements WritableSchema {
    public static final String SENSITIVE_PROPS_KEY_KEY = "key";
    public static final String SENSITIVE_PROPS_ALGORITHM_KEY = "algorithm";
    private static final String DEFAULT_ALGORITHM = "NIFI_PBKDF2_AES_GCM_256";
    private String key;
    private String algorithm = "NIFI_PBKDF2_AES_GCM_256";

    public SensitivePropsSchema() {
    }

    public SensitivePropsSchema(Map map) {
        this.key = this.getOptionalKeyAsType(map, SENSITIVE_PROPS_KEY_KEY, String.class, "Sensitive Props", "");
        this.algorithm = this.getOptionalKeyAsType(map, SENSITIVE_PROPS_ALGORITHM_KEY, String.class, "Sensitive Props", DEFAULT_ALGORITHM);
    }

    @Override
    public Map<String, Object> toMap() {
        Map result = (Map)this.mapSupplier.get();
        result.put(SENSITIVE_PROPS_KEY_KEY, this.key);
        result.put(SENSITIVE_PROPS_ALGORITHM_KEY, this.algorithm);
        return result;
    }

    public String getKey() {
        return this.key;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }
}

