/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap;

import org.apache.nifi.bootstrap.command.BootstrapCommand;
import org.apache.nifi.bootstrap.command.CommandStatus;
import org.apache.nifi.bootstrap.command.StandardBootstrapCommandProvider;
import org.apache.nifi.bootstrap.configuration.ApplicationClassName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapProcess {
    public static void main(String[] arguments) {
        StandardBootstrapCommandProvider bootstrapCommandProvider = new StandardBootstrapCommandProvider();
        BootstrapCommand bootstrapCommand = bootstrapCommandProvider.getBootstrapCommand(arguments);
        BootstrapProcess.run(bootstrapCommand);
    }

    private static void run(BootstrapCommand bootstrapCommand) {
        bootstrapCommand.run();
        CommandStatus commandStatus = bootstrapCommand.getCommandStatus();
        if (CommandStatus.RUNNING == commandStatus) {
            Logger logger = LoggerFactory.getLogger((String)ApplicationClassName.BOOTSTRAP_COMMAND.getName());
            logger.info("Bootstrap Process Running");
        } else {
            int status = commandStatus.getStatus();
            System.exit(status);
        }
    }
}

