/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import org.apache.nifi.security.util.KeystoreType;

public interface TlsConfiguration {
    public static boolean isEmpty(TlsConfiguration tlsConfiguration) {
        return tlsConfiguration == null || !tlsConfiguration.isAnyKeystorePopulated() && !tlsConfiguration.isAnyTruststorePopulated();
    }

    public String getKeystorePath();

    public String getKeystorePassword();

    public String getKeystorePasswordForLogging();

    public String getKeyPassword();

    public String getKeyPasswordForLogging();

    public String getFunctionalKeyPassword();

    public String getFunctionalKeyPasswordForLogging();

    public KeystoreType getKeystoreType();

    public String getTruststorePath();

    public String getTruststorePassword();

    public String getTruststorePasswordForLogging();

    public KeystoreType getTruststoreType();

    public String getProtocol();

    public boolean isKeystorePopulated();

    public boolean isAnyKeystorePopulated();

    public boolean isKeystoreValid();

    public boolean isTruststorePopulated();

    public boolean isAnyTruststorePopulated();

    public boolean isTruststoreValid();

    public String[] getKeystorePropertiesForLogging();

    public String[] getTruststorePropertiesForLogging();

    public String[] getEnabledProtocols();
}

