/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.v4;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.settings.Activation;
import org.apache.maven.api.settings.ActivationFile;
import org.apache.maven.api.settings.ActivationOS;
import org.apache.maven.api.settings.ActivationProperty;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.Mirror;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Proxy;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.RepositoryBase;
import org.apache.maven.api.settings.RepositoryPolicy;
import org.apache.maven.api.settings.Server;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.api.settings.TrackableBase;
import org.apache.maven.api.xml.XmlNode;

@Generated
public class SettingsMerger {
    private final boolean deepMerge;

    public SettingsMerger() {
        this(true);
    }

    public SettingsMerger(boolean deepMerge) {
        this.deepMerge = deepMerge;
    }

    public Settings merge(Settings target, Settings source, boolean sourceDominant, Map<?, ?> hints) {
        Objects.requireNonNull(target, "target cannot be null");
        if (source == null) {
            return target;
        }
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        if (hints != null) {
            context.putAll(hints);
        }
        return this.mergeSettings(target, source, sourceDominant, context);
    }

    protected TrackableBase mergeTrackableBase(TrackableBase target, TrackableBase source, boolean sourceDominant, Map<Object, Object> context) {
        TrackableBase.Builder builder = TrackableBase.newBuilder((TrackableBase)target);
        this.mergeTrackableBase(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeTrackableBase(TrackableBase.Builder builder, TrackableBase target, TrackableBase source, boolean sourceDominant, Map<Object, Object> context) {
    }

    protected IdentifiableBase mergeIdentifiableBase(IdentifiableBase target, IdentifiableBase source, boolean sourceDominant, Map<Object, Object> context) {
        IdentifiableBase.Builder builder = IdentifiableBase.newBuilder((IdentifiableBase)target);
        this.mergeIdentifiableBase(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeIdentifiableBase(IdentifiableBase.Builder builder, IdentifiableBase target, IdentifiableBase source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeTrackableBase((TrackableBase.Builder)builder, (TrackableBase)target, (TrackableBase)source, sourceDominant, context);
        this.mergeIdentifiableBase_Id(builder, target, source, sourceDominant, context);
    }

    protected void mergeIdentifiableBase_Id(IdentifiableBase.Builder builder, IdentifiableBase target, IdentifiableBase source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getId();
        String tgt = target.getId();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.id(src);
            builder.location((Object)"id", source.getLocation((Object)"id"));
        }
    }

    protected Settings mergeSettings(Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        Settings.Builder builder = Settings.newBuilder((Settings)target);
        this.mergeSettings(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeSettings(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeTrackableBase((TrackableBase.Builder)builder, (TrackableBase)target, (TrackableBase)source, sourceDominant, context);
        this.mergeSettings_LocalRepository(builder, target, source, sourceDominant, context);
        this.mergeSettings_InteractiveMode(builder, target, source, sourceDominant, context);
        this.mergeSettings_UsePluginRegistry(builder, target, source, sourceDominant, context);
        this.mergeSettings_Offline(builder, target, source, sourceDominant, context);
        this.mergeSettings_Proxies(builder, target, source, sourceDominant, context);
        this.mergeSettings_Servers(builder, target, source, sourceDominant, context);
        this.mergeSettings_Mirrors(builder, target, source, sourceDominant, context);
        this.mergeSettings_Repositories(builder, target, source, sourceDominant, context);
        this.mergeSettings_PluginRepositories(builder, target, source, sourceDominant, context);
        this.mergeSettings_Profiles(builder, target, source, sourceDominant, context);
        this.mergeSettings_ActiveProfiles(builder, target, source, sourceDominant, context);
        this.mergeSettings_PluginGroups(builder, target, source, sourceDominant, context);
    }

    protected void mergeSettings_LocalRepository(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getLocalRepository();
        String tgt = target.getLocalRepository();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.localRepository(src);
            builder.location((Object)"localRepository", source.getLocation((Object)"localRepository"));
        }
    }

    protected void mergeSettings_InteractiveMode(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant) {
            builder.interactiveMode(source.isInteractiveMode());
        }
    }

    protected void mergeSettings_UsePluginRegistry(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant) {
            builder.usePluginRegistry(source.isUsePluginRegistry());
        }
    }

    protected void mergeSettings_Offline(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant) {
            builder.offline(source.isOffline());
        }
    }

    protected void mergeSettings_Proxies(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        if (this.deepMerge) {
            builder.proxies(SettingsMerger.merge(target.getProxies(), source.getProxies(), this.getProxyKey(), (t, s) -> this.mergeProxy((Proxy)t, (Proxy)s, sourceDominant, context)));
        } else {
            builder.proxies(SettingsMerger.merge(target.getProxies(), source.getProxies(), sourceDominant, this.getProxyKey()));
        }
    }

    protected void mergeSettings_Servers(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        if (this.deepMerge) {
            builder.servers(SettingsMerger.merge(target.getServers(), source.getServers(), this.getServerKey(), (t, s) -> this.mergeServer((Server)t, (Server)s, sourceDominant, context)));
        } else {
            builder.servers(SettingsMerger.merge(target.getServers(), source.getServers(), sourceDominant, this.getServerKey()));
        }
    }

    protected void mergeSettings_Mirrors(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        if (this.deepMerge) {
            builder.mirrors(SettingsMerger.merge(target.getMirrors(), source.getMirrors(), this.getMirrorKey(), (t, s) -> this.mergeMirror((Mirror)t, (Mirror)s, sourceDominant, context)));
        } else {
            builder.mirrors(SettingsMerger.merge(target.getMirrors(), source.getMirrors(), sourceDominant, this.getMirrorKey()));
        }
    }

    protected void mergeSettings_Repositories(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        if (this.deepMerge) {
            builder.repositories(SettingsMerger.merge(target.getRepositories(), source.getRepositories(), this.getRepositoryKey(), (t, s) -> this.mergeRepository((Repository)t, (Repository)s, sourceDominant, context)));
        } else {
            builder.repositories(SettingsMerger.merge(target.getRepositories(), source.getRepositories(), sourceDominant, this.getRepositoryKey()));
        }
    }

    protected void mergeSettings_PluginRepositories(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        if (this.deepMerge) {
            builder.pluginRepositories(SettingsMerger.merge(target.getPluginRepositories(), source.getPluginRepositories(), this.getRepositoryKey(), (t, s) -> this.mergeRepository((Repository)t, (Repository)s, sourceDominant, context)));
        } else {
            builder.pluginRepositories(SettingsMerger.merge(target.getPluginRepositories(), source.getPluginRepositories(), sourceDominant, this.getRepositoryKey()));
        }
    }

    protected void mergeSettings_Profiles(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        if (this.deepMerge) {
            builder.profiles(SettingsMerger.merge(target.getProfiles(), source.getProfiles(), this.getProfileKey(), (t, s) -> this.mergeProfile((Profile)t, (Profile)s, sourceDominant, context)));
        } else {
            builder.profiles(SettingsMerger.merge(target.getProfiles(), source.getProfiles(), sourceDominant, this.getProfileKey()));
        }
    }

    protected void mergeSettings_ActiveProfiles(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        builder.activeProfiles(SettingsMerger.merge(target.getActiveProfiles(), source.getActiveProfiles(), sourceDominant, e -> e));
    }

    protected void mergeSettings_PluginGroups(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        builder.pluginGroups(SettingsMerger.merge(target.getPluginGroups(), source.getPluginGroups(), sourceDominant, e -> e));
    }

    protected Proxy mergeProxy(Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        Proxy.Builder builder = Proxy.newBuilder((Proxy)target);
        this.mergeProxy(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeProxy(Proxy.Builder builder, Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeIdentifiableBase((IdentifiableBase.Builder)builder, (IdentifiableBase)target, (IdentifiableBase)source, sourceDominant, context);
        this.mergeProxy_ActiveString(builder, target, source, sourceDominant, context);
        this.mergeProxy_Protocol(builder, target, source, sourceDominant, context);
        this.mergeProxy_Username(builder, target, source, sourceDominant, context);
        this.mergeProxy_Password(builder, target, source, sourceDominant, context);
        this.mergeProxy_PortString(builder, target, source, sourceDominant, context);
        this.mergeProxy_Host(builder, target, source, sourceDominant, context);
        this.mergeProxy_NonProxyHosts(builder, target, source, sourceDominant, context);
    }

    protected void mergeProxy_Id(Proxy.Builder builder, Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getId();
        String tgt = target.getId();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.id(src);
            builder.location((Object)"id", source.getLocation((Object)"id"));
        }
    }

    protected void mergeProxy_ActiveString(Proxy.Builder builder, Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getActiveString();
        String tgt = target.getActiveString();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.activeString(src);
            builder.location((Object)"activeString", source.getLocation((Object)"activeString"));
        }
    }

    protected void mergeProxy_Protocol(Proxy.Builder builder, Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getProtocol();
        String tgt = target.getProtocol();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.protocol(src);
            builder.location((Object)"protocol", source.getLocation((Object)"protocol"));
        }
    }

    protected void mergeProxy_Username(Proxy.Builder builder, Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUsername();
        String tgt = target.getUsername();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.username(src);
            builder.location((Object)"username", source.getLocation((Object)"username"));
        }
    }

    protected void mergeProxy_Password(Proxy.Builder builder, Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getPassword();
        String tgt = target.getPassword();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.password(src);
            builder.location((Object)"password", source.getLocation((Object)"password"));
        }
    }

    protected void mergeProxy_PortString(Proxy.Builder builder, Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getPortString();
        String tgt = target.getPortString();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.portString(src);
            builder.location((Object)"portString", source.getLocation((Object)"portString"));
        }
    }

    protected void mergeProxy_Host(Proxy.Builder builder, Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getHost();
        String tgt = target.getHost();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.host(src);
            builder.location((Object)"host", source.getLocation((Object)"host"));
        }
    }

    protected void mergeProxy_NonProxyHosts(Proxy.Builder builder, Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getNonProxyHosts();
        String tgt = target.getNonProxyHosts();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.nonProxyHosts(src);
            builder.location((Object)"nonProxyHosts", source.getLocation((Object)"nonProxyHosts"));
        }
    }

    protected Server mergeServer(Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        Server.Builder builder = Server.newBuilder((Server)target);
        this.mergeServer(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeServer(Server.Builder builder, Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeIdentifiableBase((IdentifiableBase.Builder)builder, (IdentifiableBase)target, (IdentifiableBase)source, sourceDominant, context);
        this.mergeServer_Username(builder, target, source, sourceDominant, context);
        this.mergeServer_Password(builder, target, source, sourceDominant, context);
        this.mergeServer_PrivateKey(builder, target, source, sourceDominant, context);
        this.mergeServer_Passphrase(builder, target, source, sourceDominant, context);
        this.mergeServer_FilePermissions(builder, target, source, sourceDominant, context);
        this.mergeServer_DirectoryPermissions(builder, target, source, sourceDominant, context);
        this.mergeServer_Configuration(builder, target, source, sourceDominant, context);
    }

    protected void mergeServer_Id(Server.Builder builder, Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getId();
        String tgt = target.getId();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.id(src);
            builder.location((Object)"id", source.getLocation((Object)"id"));
        }
    }

    protected void mergeServer_Username(Server.Builder builder, Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUsername();
        String tgt = target.getUsername();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.username(src);
            builder.location((Object)"username", source.getLocation((Object)"username"));
        }
    }

    protected void mergeServer_Password(Server.Builder builder, Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getPassword();
        String tgt = target.getPassword();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.password(src);
            builder.location((Object)"password", source.getLocation((Object)"password"));
        }
    }

    protected void mergeServer_PrivateKey(Server.Builder builder, Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getPrivateKey();
        String tgt = target.getPrivateKey();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.privateKey(src);
            builder.location((Object)"privateKey", source.getLocation((Object)"privateKey"));
        }
    }

    protected void mergeServer_Passphrase(Server.Builder builder, Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getPassphrase();
        String tgt = target.getPassphrase();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.passphrase(src);
            builder.location((Object)"passphrase", source.getLocation((Object)"passphrase"));
        }
    }

    protected void mergeServer_FilePermissions(Server.Builder builder, Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getFilePermissions();
        String tgt = target.getFilePermissions();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.filePermissions(src);
            builder.location((Object)"filePermissions", source.getLocation((Object)"filePermissions"));
        }
    }

    protected void mergeServer_DirectoryPermissions(Server.Builder builder, Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getDirectoryPermissions();
        String tgt = target.getDirectoryPermissions();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.directoryPermissions(src);
            builder.location((Object)"directoryPermissions", source.getLocation((Object)"directoryPermissions"));
        }
    }

    protected void mergeServer_Configuration(Server.Builder builder, Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        XmlNode src = source.getConfiguration();
        if (src != null) {
            XmlNode tgt = target.getConfiguration();
            if (tgt == null) {
                builder.configuration(src);
                builder.location((Object)"configuration", source.getLocation((Object)"configuration"));
            } else if (sourceDominant) {
                builder.configuration(src.merge(tgt));
                builder.location((Object)"configuration", target.getLocation((Object)"configuration"));
            } else {
                builder.configuration(tgt.merge(src));
                builder.location((Object)"configuration", null);
            }
        }
    }

    protected Mirror mergeMirror(Mirror target, Mirror source, boolean sourceDominant, Map<Object, Object> context) {
        Mirror.Builder builder = Mirror.newBuilder((Mirror)target);
        this.mergeMirror(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeMirror(Mirror.Builder builder, Mirror target, Mirror source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeIdentifiableBase((IdentifiableBase.Builder)builder, (IdentifiableBase)target, (IdentifiableBase)source, sourceDominant, context);
        this.mergeMirror_MirrorOf(builder, target, source, sourceDominant, context);
        this.mergeMirror_Name(builder, target, source, sourceDominant, context);
        this.mergeMirror_Url(builder, target, source, sourceDominant, context);
        this.mergeMirror_Layout(builder, target, source, sourceDominant, context);
        this.mergeMirror_MirrorOfLayouts(builder, target, source, sourceDominant, context);
        this.mergeMirror_Blocked(builder, target, source, sourceDominant, context);
    }

    protected void mergeMirror_Id(Mirror.Builder builder, Mirror target, Mirror source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getId();
        String tgt = target.getId();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.id(src);
            builder.location((Object)"id", source.getLocation((Object)"id"));
        }
    }

    protected void mergeMirror_MirrorOf(Mirror.Builder builder, Mirror target, Mirror source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getMirrorOf();
        String tgt = target.getMirrorOf();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.mirrorOf(src);
            builder.location((Object)"mirrorOf", source.getLocation((Object)"mirrorOf"));
        }
    }

    protected void mergeMirror_Name(Mirror.Builder builder, Mirror target, Mirror source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getName();
        String tgt = target.getName();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.name(src);
            builder.location((Object)"name", source.getLocation((Object)"name"));
        }
    }

    protected void mergeMirror_Url(Mirror.Builder builder, Mirror target, Mirror source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUrl();
        String tgt = target.getUrl();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.url(src);
            builder.location((Object)"url", source.getLocation((Object)"url"));
        }
    }

    protected void mergeMirror_Layout(Mirror.Builder builder, Mirror target, Mirror source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getLayout();
        String tgt = target.getLayout();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.layout(src);
            builder.location((Object)"layout", source.getLocation((Object)"layout"));
        }
    }

    protected void mergeMirror_MirrorOfLayouts(Mirror.Builder builder, Mirror target, Mirror source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getMirrorOfLayouts();
        String tgt = target.getMirrorOfLayouts();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.mirrorOfLayouts(src);
            builder.location((Object)"mirrorOfLayouts", source.getLocation((Object)"mirrorOfLayouts"));
        }
    }

    protected void mergeMirror_Blocked(Mirror.Builder builder, Mirror target, Mirror source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant) {
            builder.blocked(source.isBlocked());
        }
    }

    protected Profile mergeProfile(Profile target, Profile source, boolean sourceDominant, Map<Object, Object> context) {
        Profile.Builder builder = Profile.newBuilder((Profile)target);
        this.mergeProfile(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeProfile(Profile.Builder builder, Profile target, Profile source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeIdentifiableBase((IdentifiableBase.Builder)builder, (IdentifiableBase)target, (IdentifiableBase)source, sourceDominant, context);
        this.mergeProfile_Activation(builder, target, source, sourceDominant, context);
        this.mergeProfile_Properties(builder, target, source, sourceDominant, context);
        this.mergeProfile_Repositories(builder, target, source, sourceDominant, context);
        this.mergeProfile_PluginRepositories(builder, target, source, sourceDominant, context);
    }

    protected void mergeProfile_Id(Profile.Builder builder, Profile target, Profile source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getId();
        String tgt = target.getId();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.id(src);
            builder.location((Object)"id", source.getLocation((Object)"id"));
        }
    }

    protected void mergeProfile_Activation(Profile.Builder builder, Profile target, Profile source, boolean sourceDominant, Map<Object, Object> context) {
        Activation src = source.getActivation();
        if (src != null) {
            Activation tgt = target.getActivation();
            if (tgt == null) {
                tgt = Activation.newInstance((boolean)false);
            }
            Activation merged = this.mergeActivation(tgt, src, sourceDominant, context);
            builder.activation(merged);
            if (target.getActivation() == null) {
                builder.location((Object)"activation", source.getLocation((Object)"activation"));
            } else if (merged != tgt) {
                builder.location((Object)"activation", new InputLocation(-1, -1));
            }
        }
    }

    protected void mergeProfile_Properties(Profile.Builder builder, Profile target, Profile source, boolean sourceDominant, Map<Object, Object> context) {
        Map src = source.getProperties();
        if (!src.isEmpty()) {
            Map tgt = target.getProperties();
            if (tgt.isEmpty()) {
                builder.properties(src);
                builder.location((Object)"properties", source.getLocation((Object)"properties"));
            } else {
                HashMap merged = new HashMap();
                merged.putAll(sourceDominant ? target.getProperties() : source.getProperties());
                merged.putAll(sourceDominant ? source.getProperties() : target.getProperties());
                builder.properties(merged);
                builder.location((Object)"properties", InputLocation.merge((InputLocation)target.getLocation((Object)"properties"), (InputLocation)source.getLocation((Object)"properties"), (boolean)sourceDominant));
            }
        }
    }

    protected void mergeProfile_Repositories(Profile.Builder builder, Profile target, Profile source, boolean sourceDominant, Map<Object, Object> context) {
        if (this.deepMerge) {
            builder.repositories(SettingsMerger.merge(target.getRepositories(), source.getRepositories(), this.getRepositoryKey(), (t, s) -> this.mergeRepository((Repository)t, (Repository)s, sourceDominant, context)));
        } else {
            builder.repositories(SettingsMerger.merge(target.getRepositories(), source.getRepositories(), sourceDominant, this.getRepositoryKey()));
        }
    }

    protected void mergeProfile_PluginRepositories(Profile.Builder builder, Profile target, Profile source, boolean sourceDominant, Map<Object, Object> context) {
        if (this.deepMerge) {
            builder.pluginRepositories(SettingsMerger.merge(target.getPluginRepositories(), source.getPluginRepositories(), this.getRepositoryKey(), (t, s) -> this.mergeRepository((Repository)t, (Repository)s, sourceDominant, context)));
        } else {
            builder.pluginRepositories(SettingsMerger.merge(target.getPluginRepositories(), source.getPluginRepositories(), sourceDominant, this.getRepositoryKey()));
        }
    }

    protected Activation mergeActivation(Activation target, Activation source, boolean sourceDominant, Map<Object, Object> context) {
        Activation.Builder builder = Activation.newBuilder((Activation)target);
        this.mergeActivation(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeActivation(Activation.Builder builder, Activation target, Activation source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeActivation_ActiveByDefault(builder, target, source, sourceDominant, context);
        this.mergeActivation_Jdk(builder, target, source, sourceDominant, context);
        this.mergeActivation_Os(builder, target, source, sourceDominant, context);
        this.mergeActivation_Property(builder, target, source, sourceDominant, context);
        this.mergeActivation_File(builder, target, source, sourceDominant, context);
        this.mergeActivation_Packaging(builder, target, source, sourceDominant, context);
        this.mergeActivation_Condition(builder, target, source, sourceDominant, context);
    }

    protected void mergeActivation_ActiveByDefault(Activation.Builder builder, Activation target, Activation source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant) {
            builder.activeByDefault(source.isActiveByDefault());
        }
    }

    protected void mergeActivation_Jdk(Activation.Builder builder, Activation target, Activation source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getJdk();
        String tgt = target.getJdk();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.jdk(src);
            builder.location((Object)"jdk", source.getLocation((Object)"jdk"));
        }
    }

    protected void mergeActivation_Os(Activation.Builder builder, Activation target, Activation source, boolean sourceDominant, Map<Object, Object> context) {
        ActivationOS src = source.getOs();
        if (src != null) {
            ActivationOS tgt = target.getOs();
            if (tgt == null) {
                tgt = ActivationOS.newInstance((boolean)false);
            }
            ActivationOS merged = this.mergeActivationOS(tgt, src, sourceDominant, context);
            builder.os(merged);
            if (target.getOs() == null) {
                builder.location((Object)"os", source.getLocation((Object)"os"));
            } else if (merged != tgt) {
                builder.location((Object)"os", new InputLocation(-1, -1));
            }
        }
    }

    protected void mergeActivation_Property(Activation.Builder builder, Activation target, Activation source, boolean sourceDominant, Map<Object, Object> context) {
        ActivationProperty src = source.getProperty();
        if (src != null) {
            ActivationProperty tgt = target.getProperty();
            if (tgt == null) {
                tgt = ActivationProperty.newInstance((boolean)false);
            }
            ActivationProperty merged = this.mergeActivationProperty(tgt, src, sourceDominant, context);
            builder.property(merged);
            if (target.getProperty() == null) {
                builder.location((Object)"property", source.getLocation((Object)"property"));
            } else if (merged != tgt) {
                builder.location((Object)"property", new InputLocation(-1, -1));
            }
        }
    }

    protected void mergeActivation_File(Activation.Builder builder, Activation target, Activation source, boolean sourceDominant, Map<Object, Object> context) {
        ActivationFile src = source.getFile();
        if (src != null) {
            ActivationFile tgt = target.getFile();
            if (tgt == null) {
                tgt = ActivationFile.newInstance((boolean)false);
            }
            ActivationFile merged = this.mergeActivationFile(tgt, src, sourceDominant, context);
            builder.file(merged);
            if (target.getFile() == null) {
                builder.location((Object)"file", source.getLocation((Object)"file"));
            } else if (merged != tgt) {
                builder.location((Object)"file", new InputLocation(-1, -1));
            }
        }
    }

    protected void mergeActivation_Packaging(Activation.Builder builder, Activation target, Activation source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getPackaging();
        String tgt = target.getPackaging();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.packaging(src);
            builder.location((Object)"packaging", source.getLocation((Object)"packaging"));
        }
    }

    protected void mergeActivation_Condition(Activation.Builder builder, Activation target, Activation source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getCondition();
        String tgt = target.getCondition();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.condition(src);
            builder.location((Object)"condition", source.getLocation((Object)"condition"));
        }
    }

    protected RepositoryBase mergeRepositoryBase(RepositoryBase target, RepositoryBase source, boolean sourceDominant, Map<Object, Object> context) {
        RepositoryBase.Builder builder = RepositoryBase.newBuilder((RepositoryBase)target);
        this.mergeRepositoryBase(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeRepositoryBase(RepositoryBase.Builder builder, RepositoryBase target, RepositoryBase source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeIdentifiableBase((IdentifiableBase.Builder)builder, (IdentifiableBase)target, (IdentifiableBase)source, sourceDominant, context);
        this.mergeRepositoryBase_Name(builder, target, source, sourceDominant, context);
        this.mergeRepositoryBase_Url(builder, target, source, sourceDominant, context);
        this.mergeRepositoryBase_Layout(builder, target, source, sourceDominant, context);
    }

    protected void mergeRepositoryBase_Id(RepositoryBase.Builder builder, RepositoryBase target, RepositoryBase source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getId();
        String tgt = target.getId();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.id(src);
            builder.location((Object)"id", source.getLocation((Object)"id"));
        }
    }

    protected void mergeRepositoryBase_Name(RepositoryBase.Builder builder, RepositoryBase target, RepositoryBase source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getName();
        String tgt = target.getName();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.name(src);
            builder.location((Object)"name", source.getLocation((Object)"name"));
        }
    }

    protected void mergeRepositoryBase_Url(RepositoryBase.Builder builder, RepositoryBase target, RepositoryBase source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUrl();
        String tgt = target.getUrl();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.url(src);
            builder.location((Object)"url", source.getLocation((Object)"url"));
        }
    }

    protected void mergeRepositoryBase_Layout(RepositoryBase.Builder builder, RepositoryBase target, RepositoryBase source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getLayout();
        String tgt = target.getLayout();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.layout(src);
            builder.location((Object)"layout", source.getLocation((Object)"layout"));
        }
    }

    protected Repository mergeRepository(Repository target, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        Repository.Builder builder = Repository.newBuilder((Repository)target);
        this.mergeRepository(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeRepository(Repository.Builder builder, Repository target, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeRepositoryBase((RepositoryBase.Builder)builder, (RepositoryBase)target, (RepositoryBase)source, sourceDominant, context);
        this.mergeRepository_Releases(builder, target, source, sourceDominant, context);
        this.mergeRepository_Snapshots(builder, target, source, sourceDominant, context);
    }

    protected void mergeRepository_Id(Repository.Builder builder, Repository target, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getId();
        String tgt = target.getId();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.id(src);
            builder.location((Object)"id", source.getLocation((Object)"id"));
        }
    }

    protected void mergeRepository_Name(Repository.Builder builder, Repository target, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getName();
        String tgt = target.getName();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.name(src);
            builder.location((Object)"name", source.getLocation((Object)"name"));
        }
    }

    protected void mergeRepository_Url(Repository.Builder builder, Repository target, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUrl();
        String tgt = target.getUrl();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.url(src);
            builder.location((Object)"url", source.getLocation((Object)"url"));
        }
    }

    protected void mergeRepository_Layout(Repository.Builder builder, Repository target, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getLayout();
        String tgt = target.getLayout();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.layout(src);
            builder.location((Object)"layout", source.getLocation((Object)"layout"));
        }
    }

    protected void mergeRepository_Releases(Repository.Builder builder, Repository target, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        RepositoryPolicy src = source.getReleases();
        if (src != null) {
            RepositoryPolicy tgt = target.getReleases();
            if (tgt == null) {
                tgt = RepositoryPolicy.newInstance((boolean)false);
            }
            RepositoryPolicy merged = this.mergeRepositoryPolicy(tgt, src, sourceDominant, context);
            builder.releases(merged);
            if (target.getReleases() == null) {
                builder.location((Object)"releases", source.getLocation((Object)"releases"));
            } else if (merged != tgt) {
                builder.location((Object)"releases", new InputLocation(-1, -1));
            }
        }
    }

    protected void mergeRepository_Snapshots(Repository.Builder builder, Repository target, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        RepositoryPolicy src = source.getSnapshots();
        if (src != null) {
            RepositoryPolicy tgt = target.getSnapshots();
            if (tgt == null) {
                tgt = RepositoryPolicy.newInstance((boolean)false);
            }
            RepositoryPolicy merged = this.mergeRepositoryPolicy(tgt, src, sourceDominant, context);
            builder.snapshots(merged);
            if (target.getSnapshots() == null) {
                builder.location((Object)"snapshots", source.getLocation((Object)"snapshots"));
            } else if (merged != tgt) {
                builder.location((Object)"snapshots", new InputLocation(-1, -1));
            }
        }
    }

    protected RepositoryPolicy mergeRepositoryPolicy(RepositoryPolicy target, RepositoryPolicy source, boolean sourceDominant, Map<Object, Object> context) {
        RepositoryPolicy.Builder builder = RepositoryPolicy.newBuilder((RepositoryPolicy)target);
        this.mergeRepositoryPolicy(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeRepositoryPolicy(RepositoryPolicy.Builder builder, RepositoryPolicy target, RepositoryPolicy source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeRepositoryPolicy_Enabled(builder, target, source, sourceDominant, context);
        this.mergeRepositoryPolicy_UpdatePolicy(builder, target, source, sourceDominant, context);
        this.mergeRepositoryPolicy_ChecksumPolicy(builder, target, source, sourceDominant, context);
    }

    protected void mergeRepositoryPolicy_Enabled(RepositoryPolicy.Builder builder, RepositoryPolicy target, RepositoryPolicy source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant) {
            builder.enabled(source.isEnabled());
        }
    }

    protected void mergeRepositoryPolicy_UpdatePolicy(RepositoryPolicy.Builder builder, RepositoryPolicy target, RepositoryPolicy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUpdatePolicy();
        String tgt = target.getUpdatePolicy();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.updatePolicy(src);
            builder.location((Object)"updatePolicy", source.getLocation((Object)"updatePolicy"));
        }
    }

    protected void mergeRepositoryPolicy_ChecksumPolicy(RepositoryPolicy.Builder builder, RepositoryPolicy target, RepositoryPolicy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getChecksumPolicy();
        String tgt = target.getChecksumPolicy();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.checksumPolicy(src);
            builder.location((Object)"checksumPolicy", source.getLocation((Object)"checksumPolicy"));
        }
    }

    protected ActivationProperty mergeActivationProperty(ActivationProperty target, ActivationProperty source, boolean sourceDominant, Map<Object, Object> context) {
        ActivationProperty.Builder builder = ActivationProperty.newBuilder((ActivationProperty)target);
        this.mergeActivationProperty(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeActivationProperty(ActivationProperty.Builder builder, ActivationProperty target, ActivationProperty source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeActivationProperty_Name(builder, target, source, sourceDominant, context);
        this.mergeActivationProperty_Value(builder, target, source, sourceDominant, context);
    }

    protected void mergeActivationProperty_Name(ActivationProperty.Builder builder, ActivationProperty target, ActivationProperty source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getName();
        String tgt = target.getName();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.name(src);
            builder.location((Object)"name", source.getLocation((Object)"name"));
        }
    }

    protected void mergeActivationProperty_Value(ActivationProperty.Builder builder, ActivationProperty target, ActivationProperty source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getValue();
        String tgt = target.getValue();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.value(src);
            builder.location((Object)"value", source.getLocation((Object)"value"));
        }
    }

    protected ActivationOS mergeActivationOS(ActivationOS target, ActivationOS source, boolean sourceDominant, Map<Object, Object> context) {
        ActivationOS.Builder builder = ActivationOS.newBuilder((ActivationOS)target);
        this.mergeActivationOS(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeActivationOS(ActivationOS.Builder builder, ActivationOS target, ActivationOS source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeActivationOS_Name(builder, target, source, sourceDominant, context);
        this.mergeActivationOS_Family(builder, target, source, sourceDominant, context);
        this.mergeActivationOS_Arch(builder, target, source, sourceDominant, context);
        this.mergeActivationOS_Version(builder, target, source, sourceDominant, context);
    }

    protected void mergeActivationOS_Name(ActivationOS.Builder builder, ActivationOS target, ActivationOS source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getName();
        String tgt = target.getName();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.name(src);
            builder.location((Object)"name", source.getLocation((Object)"name"));
        }
    }

    protected void mergeActivationOS_Family(ActivationOS.Builder builder, ActivationOS target, ActivationOS source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getFamily();
        String tgt = target.getFamily();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.family(src);
            builder.location((Object)"family", source.getLocation((Object)"family"));
        }
    }

    protected void mergeActivationOS_Arch(ActivationOS.Builder builder, ActivationOS target, ActivationOS source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getArch();
        String tgt = target.getArch();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.arch(src);
            builder.location((Object)"arch", source.getLocation((Object)"arch"));
        }
    }

    protected void mergeActivationOS_Version(ActivationOS.Builder builder, ActivationOS target, ActivationOS source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getVersion();
        String tgt = target.getVersion();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.version(src);
            builder.location((Object)"version", source.getLocation((Object)"version"));
        }
    }

    protected ActivationFile mergeActivationFile(ActivationFile target, ActivationFile source, boolean sourceDominant, Map<Object, Object> context) {
        ActivationFile.Builder builder = ActivationFile.newBuilder((ActivationFile)target);
        this.mergeActivationFile(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeActivationFile(ActivationFile.Builder builder, ActivationFile target, ActivationFile source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeActivationFile_Missing(builder, target, source, sourceDominant, context);
        this.mergeActivationFile_Exists(builder, target, source, sourceDominant, context);
    }

    protected void mergeActivationFile_Missing(ActivationFile.Builder builder, ActivationFile target, ActivationFile source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getMissing();
        String tgt = target.getMissing();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.missing(src);
            builder.location((Object)"missing", source.getLocation((Object)"missing"));
        }
    }

    protected void mergeActivationFile_Exists(ActivationFile.Builder builder, ActivationFile target, ActivationFile source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getExists();
        String tgt = target.getExists();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.exists(src);
            builder.location((Object)"exists", source.getLocation((Object)"exists"));
        }
    }

    protected KeyComputer<TrackableBase> getTrackableBaseKey() {
        return v -> v;
    }

    protected KeyComputer<IdentifiableBase> getIdentifiableBaseKey() {
        return v -> v;
    }

    protected KeyComputer<Settings> getSettingsKey() {
        return v -> v;
    }

    protected KeyComputer<Proxy> getProxyKey() {
        return v -> v;
    }

    protected KeyComputer<Server> getServerKey() {
        return v -> v;
    }

    protected KeyComputer<Mirror> getMirrorKey() {
        return v -> v;
    }

    protected KeyComputer<Profile> getProfileKey() {
        return v -> v;
    }

    protected KeyComputer<Activation> getActivationKey() {
        return v -> v;
    }

    protected KeyComputer<RepositoryBase> getRepositoryBaseKey() {
        return v -> v;
    }

    protected KeyComputer<Repository> getRepositoryKey() {
        return v -> v;
    }

    protected KeyComputer<RepositoryPolicy> getRepositoryPolicyKey() {
        return v -> v;
    }

    protected KeyComputer<ActivationProperty> getActivationPropertyKey() {
        return v -> v;
    }

    protected KeyComputer<ActivationOS> getActivationOSKey() {
        return v -> v;
    }

    protected KeyComputer<ActivationFile> getActivationFileKey() {
        return v -> v;
    }

    public static <T> List<T> merge(List<T> tgt, List<T> src, boolean sourceDominant, KeyComputer<T> computer) {
        return SettingsMerger.merge(tgt, src, computer, (t, s) -> sourceDominant ? s : t);
    }

    public static <T> List<T> merge(List<T> tgt, List<T> src, KeyComputer<T> computer, BinaryOperator<T> remapping) {
        MergingList<T> list;
        if (src.isEmpty()) {
            return tgt;
        }
        if (tgt instanceof MergingList) {
            list = (MergingList<T>)tgt;
        } else {
            list = new MergingList<T>(computer, src.size() + tgt.size());
            list.mergeAll(tgt, (t, s) -> s);
        }
        list.mergeAll(src, remapping);
        return list;
    }

    @FunctionalInterface
    public static interface KeyComputer<T>
    extends Function<T, Object> {
    }

    private static class MergingList<V>
    extends AbstractList<V>
    implements Serializable {
        private final KeyComputer<V> keyComputer;
        private Map<Object, V> map;
        private List<V> list;

        MergingList(KeyComputer<V> keyComputer, int initialCapacity) {
            this.map = new LinkedHashMap<Object, V>(initialCapacity);
            this.keyComputer = keyComputer;
        }

        Object writeReplace() throws ObjectStreamException {
            return new ArrayList(this);
        }

        @Override
        public Iterator<V> iterator() {
            if (this.map != null) {
                return this.map.values().iterator();
            }
            return this.list.iterator();
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        void mergeAll(Collection<V> vs, BinaryOperator<V> remapping) {
            if (this.map == null) {
                this.map = this.list.stream().collect(Collectors.toMap(this.keyComputer, Function.identity(), null, LinkedHashMap::new));
                this.list = null;
            }
            if (vs instanceof MergingList) {
                MergingList mergingList = (MergingList)vs;
                if (((MergingList)vs).map != null) {
                    Iterator<Map.Entry<Object, V>> iterator = ((MergingList)vs).map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<Object, V> e = iterator.next();
                        Object key = e.getKey();
                        V v = e.getValue();
                        this.map.merge(key, v, remapping);
                    }
                    return;
                }
            }
            Iterator<V> iterator = vs.iterator();
            while (iterator.hasNext()) {
                V v = iterator.next();
                Object key = this.keyComputer.apply(v);
                this.map.merge(key, v, remapping);
            }
        }

        @Override
        public boolean contains(Object o) {
            if (this.map != null) {
                return this.map.containsValue(o);
            }
            return this.list.contains(o);
        }

        private List<V> asList() {
            if (this.list == null) {
                this.list = new ArrayList<V>(this.map.values());
                this.map = null;
            }
            return this.list;
        }

        @Override
        public void add(int index, V element) {
            this.asList().add(index, element);
        }

        @Override
        public V remove(int index) {
            return this.asList().remove(index);
        }

        @Override
        public V get(int index) {
            return this.asList().get(index);
        }

        @Override
        public int size() {
            if (this.map != null) {
                return this.map.size();
            }
            return this.list.size();
        }
    }
}

