/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.BuiltinIdentities;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.IdentityUtils;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.FileInfoExtractor;
import org.apache.sshd.common.util.io.IoUtils;

public final class ClientIdentity {
    public static final String ID_FILE_PREFIX = "id_";
    public static final String ID_FILE_SUFFIX = "";
    public static final Function<String, String> ID_GENERATOR = ClientIdentity::getIdentityFileName;

    private ClientIdentity() {
        throw new UnsupportedOperationException("No instance");
    }

    public static String getIdentityType(String name) {
        if (GenericUtils.isEmpty(name) || name.length() <= ID_FILE_PREFIX.length() || !name.startsWith(ID_FILE_PREFIX)) {
            return null;
        }
        return name.substring(ID_FILE_PREFIX.length());
    }

    public static String getIdentityFileName(NamedResource r) {
        return ClientIdentity.getIdentityFileName(r == null ? null : r.getName());
    }

    public static String getIdentityFileName(String type) {
        return IdentityUtils.getIdentityFileName(ID_FILE_PREFIX, type, ID_FILE_SUFFIX);
    }

    public static <C extends SshClient> C setKeyPairProvider(C client, boolean strict, boolean supportedOnly, FilePasswordProvider provider, LinkOption ... options) throws IOException, GeneralSecurityException {
        return ClientIdentity.setKeyPairProvider(client, PublicKeyEntry.getDefaultKeysFolderPath(), strict, supportedOnly, provider, options);
    }

    public static <C extends SshClient> C setKeyPairProvider(C client, Path dir, boolean strict, boolean supportedOnly, FilePasswordProvider provider, LinkOption ... options) throws IOException, GeneralSecurityException {
        KeyPairProvider kpp = ClientIdentity.loadDefaultKeyPairProvider(dir, strict, supportedOnly, provider, options);
        if (kpp != null) {
            client.setKeyPairProvider(kpp);
        }
        return client;
    }

    public static KeyPairProvider loadDefaultKeyPairProvider(boolean strict, boolean supportedOnly, FilePasswordProvider provider, LinkOption ... options) throws IOException, GeneralSecurityException {
        return ClientIdentity.loadDefaultKeyPairProvider(PublicKeyEntry.getDefaultKeysFolderPath(), strict, supportedOnly, provider, options);
    }

    public static KeyPairProvider loadDefaultKeyPairProvider(Path dir, boolean strict, boolean supportedOnly, FilePasswordProvider provider, LinkOption ... options) throws IOException, GeneralSecurityException {
        Map<String, KeyPair> ids = ClientIdentity.loadDefaultIdentities(dir, strict, provider, options);
        return IdentityUtils.createKeyPairProvider(ids, supportedOnly);
    }

    public static Map<String, KeyPair> loadDefaultIdentities(boolean strict, FilePasswordProvider provider, LinkOption ... options) throws IOException, GeneralSecurityException {
        return ClientIdentity.loadDefaultIdentities(PublicKeyEntry.getDefaultKeysFolderPath(), strict, provider, options);
    }

    public static Map<String, KeyPair> loadDefaultIdentities(Path dir, boolean strict, FilePasswordProvider provider, LinkOption ... options) throws IOException, GeneralSecurityException {
        return ClientIdentity.loadIdentities(dir, strict, BuiltinIdentities.NAMES, ID_GENERATOR, provider, options);
    }

    public static Map<String, KeyPair> loadIdentities(Path dir, boolean strict, Collection<String> types, Function<String, String> idGenerator, FilePasswordProvider provider, LinkOption ... options) throws IOException, GeneralSecurityException {
        Map<String, Path> paths = ClientIdentity.scanIdentitiesFolder(dir, strict, types, idGenerator, options);
        return IdentityUtils.loadIdentities(paths, provider, IoUtils.EMPTY_OPEN_OPTIONS);
    }

    public static Map<String, Path> scanIdentitiesFolder(Path dir, boolean strict, Collection<String> types, Function<String, String> idGenerator, LinkOption ... options) throws IOException {
        if (GenericUtils.isEmpty(types)) {
            return Collections.emptyMap();
        }
        if (!Files.exists(dir, options)) {
            return Collections.emptyMap();
        }
        ValidateUtils.checkTrue((boolean)FileInfoExtractor.ISDIR.infoOf(dir, options), "Not a directory: %s", (Object)dir);
        TreeMap<String, Path> paths = new TreeMap<String, Path>(String.CASE_INSENSITIVE_ORDER);
        for (String t : types) {
            String fileName = idGenerator.apply(t);
            Path p = dir.resolve(fileName);
            if (!Files.exists(p, options) || strict && KeyUtils.validateStrictKeyFilePermissions(p, options) != null) continue;
            Path prev = paths.put(t, p);
            ValidateUtils.checkTrue(prev == null, "Multiple mappings for type=%s", (Object)t);
        }
        return paths;
    }
}

