/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.converter;

import org.apache.juneau.BeanSession;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.objecttools.ObjectIntrospector;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.converter.RestConverter;
import org.apache.juneau.swap.ObjectSwap;

public class Introspectable
implements RestConverter {
    public static final String SWAGGER_PARAMS = "{in:'query',name:'invokeMethod',description:' The Java method name, optionally with arguments if necessary to differentiate between methods.',examples:{example:'toString'}},\n{in:'query',name:'invokeArgs',description:'The arguments as an array.',examples:{example:'foo,bar'}}\n";

    @Override
    public Object convert(RestRequest req, Object o) throws InternalServerError {
        String method = req.getQueryParam("invokeMethod").orElse(null);
        String args = req.getQueryParam("invokeArgs").orElse(null);
        if (method == null) {
            return o;
        }
        try {
            BeanSession bs = req.getBeanSession();
            ObjectSwap swap = bs.getClassMetaForObject(o).getSwap(bs);
            if (Utils.nn((Object)swap)) {
                o = swap.swap(bs, o);
            }
            return ObjectIntrospector.create((Object)o, (ReaderParser)JsonParser.DEFAULT).invokeMethod(method, args);
        }
        catch (Exception e) {
            return new InternalServerError((Throwable)e, "Error occurred trying to invoke method: {0}", new Object[]{ThrowableUtils.lm((Throwable)e)});
        }
    }
}

