/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem.store.roaring.strategies;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem.pattern.MatchPattern;
import org.apache.jena.mem.pattern.PatternClassifier;
import org.apache.jena.mem.store.roaring.NodesToBitmapsMap;
import org.apache.jena.mem.store.roaring.RoaringBitmapTripleIterator;
import org.apache.jena.mem.store.roaring.TripleSet;
import org.apache.jena.mem.store.roaring.strategies.StoreStrategy;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.roaringbitmap.FastAggregation;
import org.roaringbitmap.ImmutableBitmapDataProvider;
import org.roaringbitmap.RoaringBitmap;

public class EagerStoreStrategy
implements StoreStrategy {
    private static final RoaringBitmap EMPTY_BITMAP = new RoaringBitmap();
    private static final String UNSUPPORTED_PATTERN_CLASSIFIER = "Unsupported pattern classifier: %s";
    final NodesToBitmapsMap[] spoBitmaps;
    final TripleSet triples;

    public EagerStoreStrategy(TripleSet triples, boolean parallel) {
        this(triples);
        if (parallel) {
            this.indexAllParallel();
        } else {
            this.indexAll();
        }
    }

    public EagerStoreStrategy(TripleSet triples) {
        this.triples = triples;
        this.spoBitmaps = new NodesToBitmapsMap[]{new NodesToBitmapsMap(), new NodesToBitmapsMap(), new NodesToBitmapsMap()};
    }

    public EagerStoreStrategy(TripleSet triples, EagerStoreStrategy strategyToCopyBitmapsFrom) {
        this.triples = triples;
        this.spoBitmaps = new NodesToBitmapsMap[]{strategyToCopyBitmapsFrom.spoBitmaps[0].copy(), strategyToCopyBitmapsFrom.spoBitmaps[1].copy(), strategyToCopyBitmapsFrom.spoBitmaps[2].copy()};
    }

    private void indexAll() {
        this.triples.indexedKeyIterator().forEachRemaining(entry -> this.addToIndex((Triple)entry.key(), entry.index()));
    }

    private void indexAllParallel() {
        CompletableFuture<Void> futureIndexSubjects = CompletableFuture.runAsync(() -> this.triples.indexedKeyIterator().forEachRemaining(entry -> EagerStoreStrategy.addIndex(this.spoBitmaps[0], ((Triple)entry.key()).getSubject(), entry.index())));
        CompletableFuture<Void> futureIndexPredicates = CompletableFuture.runAsync(() -> this.triples.indexedKeyIterator().forEachRemaining(entry -> EagerStoreStrategy.addIndex(this.spoBitmaps[1], ((Triple)entry.key()).getPredicate(), entry.index())));
        this.triples.indexedKeyIterator().forEachRemaining(entry -> EagerStoreStrategy.addIndex(this.spoBitmaps[2], ((Triple)entry.key()).getObject(), entry.index()));
        CompletableFuture.allOf(futureIndexSubjects, futureIndexPredicates).join();
    }

    private static void addIndex(NodesToBitmapsMap map, Node node, int index) {
        RoaringBitmap bitmap = map.computeIfAbsent(node, RoaringBitmap::new);
        bitmap.add(index);
    }

    private static void removeIndex(NodesToBitmapsMap map, Node node, int index) {
        RoaringBitmap bitmap = (RoaringBitmap)map.get(node);
        bitmap.remove(index);
        if (bitmap.isEmpty()) {
            map.removeUnchecked(node);
        }
    }

    @Override
    public void addToIndex(Triple triple, int index) {
        EagerStoreStrategy.addIndex(this.spoBitmaps[0], triple.getSubject(), index);
        EagerStoreStrategy.addIndex(this.spoBitmaps[1], triple.getPredicate(), index);
        EagerStoreStrategy.addIndex(this.spoBitmaps[2], triple.getObject(), index);
    }

    @Override
    public void removeFromIndex(Triple triple, int index) {
        EagerStoreStrategy.removeIndex(this.spoBitmaps[0], triple.getSubject(), index);
        EagerStoreStrategy.removeIndex(this.spoBitmaps[1], triple.getPredicate(), index);
        EagerStoreStrategy.removeIndex(this.spoBitmaps[2], triple.getObject(), index);
    }

    @Override
    public void clearIndex() {
        for (NodesToBitmapsMap bitmapMap : this.spoBitmaps) {
            bitmapMap.clear();
        }
    }

    @Override
    public boolean containsMatch(Triple tripleMatch, MatchPattern pattern) {
        switch (pattern) {
            case SUB_ANY_ANY: {
                return this.spoBitmaps[0].containsKey(tripleMatch.getSubject());
            }
            case ANY_PRE_ANY: {
                return this.spoBitmaps[1].containsKey(tripleMatch.getPredicate());
            }
            case ANY_ANY_OBJ: {
                return this.spoBitmaps[2].containsKey(tripleMatch.getObject());
            }
            case SUB_PRE_ANY: {
                RoaringBitmap subjectBitmap = (RoaringBitmap)this.spoBitmaps[0].get(tripleMatch.getSubject());
                if (null == subjectBitmap) {
                    return false;
                }
                RoaringBitmap predicateBitmap = (RoaringBitmap)this.spoBitmaps[1].get(tripleMatch.getPredicate());
                if (null == predicateBitmap) {
                    return false;
                }
                return RoaringBitmap.intersects(subjectBitmap, predicateBitmap);
            }
            case ANY_PRE_OBJ: {
                RoaringBitmap predicateBitmap = (RoaringBitmap)this.spoBitmaps[1].get(tripleMatch.getPredicate());
                if (null == predicateBitmap) {
                    return false;
                }
                RoaringBitmap objectBitmap = (RoaringBitmap)this.spoBitmaps[2].get(tripleMatch.getObject());
                if (null == objectBitmap) {
                    return false;
                }
                return RoaringBitmap.intersects(objectBitmap, predicateBitmap);
            }
            case SUB_ANY_OBJ: {
                RoaringBitmap subjectBitmap = (RoaringBitmap)this.spoBitmaps[0].get(tripleMatch.getSubject());
                if (null == subjectBitmap) {
                    return false;
                }
                RoaringBitmap objectBitmap = (RoaringBitmap)this.spoBitmaps[2].get(tripleMatch.getObject());
                if (null == objectBitmap) {
                    return false;
                }
                return RoaringBitmap.intersects(subjectBitmap, objectBitmap);
            }
        }
        throw new IllegalStateException(String.format(UNSUPPORTED_PATTERN_CLASSIFIER, new Object[]{PatternClassifier.classify(tripleMatch)}));
    }

    @Override
    public Stream<Triple> streamMatch(Triple tripleMatch, MatchPattern pattern) {
        return this.getBitmapForMatch(tripleMatch, pattern).stream().mapToObj(this.triples::getKeyAt);
    }

    @Override
    public ExtendedIterator<Triple> findMatch(Triple tripleMatch, MatchPattern pattern) {
        return new RoaringBitmapTripleIterator(this.getBitmapForMatch(tripleMatch, pattern), this.triples);
    }

    private ImmutableBitmapDataProvider getBitmapForMatch(Triple tripleMatch, MatchPattern matchPattern) {
        switch (matchPattern) {
            case SUB_ANY_ANY: {
                return this.spoBitmaps[0].getOrDefault(tripleMatch.getSubject(), EMPTY_BITMAP);
            }
            case ANY_PRE_ANY: {
                return this.spoBitmaps[1].getOrDefault(tripleMatch.getPredicate(), EMPTY_BITMAP);
            }
            case ANY_ANY_OBJ: {
                return this.spoBitmaps[2].getOrDefault(tripleMatch.getObject(), EMPTY_BITMAP);
            }
            case SUB_PRE_ANY: {
                RoaringBitmap subjectBitmap = (RoaringBitmap)this.spoBitmaps[0].get(tripleMatch.getSubject());
                if (null == subjectBitmap) {
                    return EMPTY_BITMAP;
                }
                RoaringBitmap predicateBitmap = (RoaringBitmap)this.spoBitmaps[1].get(tripleMatch.getPredicate());
                if (null == predicateBitmap) {
                    return EMPTY_BITMAP;
                }
                return FastAggregation.naive_and(subjectBitmap, predicateBitmap);
            }
            case ANY_PRE_OBJ: {
                RoaringBitmap predicateBitmap = (RoaringBitmap)this.spoBitmaps[1].get(tripleMatch.getPredicate());
                if (null == predicateBitmap) {
                    return EMPTY_BITMAP;
                }
                RoaringBitmap objectBitmap = (RoaringBitmap)this.spoBitmaps[2].get(tripleMatch.getObject());
                if (null == objectBitmap) {
                    return EMPTY_BITMAP;
                }
                return FastAggregation.naive_and(predicateBitmap, objectBitmap);
            }
            case SUB_ANY_OBJ: {
                RoaringBitmap subjectBitmap = (RoaringBitmap)this.spoBitmaps[0].get(tripleMatch.getSubject());
                if (null == subjectBitmap) {
                    return EMPTY_BITMAP;
                }
                RoaringBitmap objectBitmap = (RoaringBitmap)this.spoBitmaps[2].get(tripleMatch.getObject());
                if (null == objectBitmap) {
                    return EMPTY_BITMAP;
                }
                return FastAggregation.naive_and(subjectBitmap, objectBitmap);
            }
        }
        throw new IllegalStateException(String.format(UNSUPPORTED_PATTERN_CLASSIFIER, new Object[]{PatternClassifier.classify(tripleMatch)}));
    }
}

