/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import org.apache.james.backends.cassandra.components.CassandraDataDefinition;
import org.apache.james.backends.rabbitmq.SimpleConnectionPool;
import org.apache.james.mailbox.cassandra.DeleteMessageListener;
import org.apache.james.modules.mailbox.DeletedMessageVaultWorkQueueReconnectionHandler;
import org.apache.james.modules.mailbox.DistributedDeletedMessageVaultDeletionCallback;
import org.apache.james.modules.vault.DeletedMessageVaultModule;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.apache.james.vault.DeletedMessageVault;
import org.apache.james.vault.blob.BlobStoreDeletedMessageVault;
import org.apache.james.vault.blob.BucketNameGenerator;
import org.apache.james.vault.dto.DeletedMessageWithStorageInformationConverter;
import org.apache.james.vault.metadata.CassandraDeletedMessageMetadataVault;
import org.apache.james.vault.metadata.DeletedMessageMetadataDataDefinition;
import org.apache.james.vault.metadata.DeletedMessageMetadataVault;
import org.apache.james.vault.metadata.MetadataDAO;
import org.apache.james.vault.metadata.StorageInformationDAO;
import org.apache.james.vault.metadata.UserPerBucketDAO;

public class DistributedDeletedMessageVaultModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new DeletedMessageVaultModule());
        Multibinder cassandraDataDefinitions = Multibinder.newSetBinder((Binder)this.binder(), CassandraDataDefinition.class);
        cassandraDataDefinitions.addBinding().toInstance((Object)DeletedMessageMetadataDataDefinition.MODULE);
        this.bind(MetadataDAO.class).in(Scopes.SINGLETON);
        this.bind(StorageInformationDAO.class).in(Scopes.SINGLETON);
        this.bind(UserPerBucketDAO.class).in(Scopes.SINGLETON);
        this.bind(DeletedMessageWithStorageInformationConverter.class).in(Scopes.SINGLETON);
        this.bind(CassandraDeletedMessageMetadataVault.class).in(Scopes.SINGLETON);
        this.bind(DeletedMessageMetadataVault.class).to(CassandraDeletedMessageMetadataVault.class);
        this.bind(BucketNameGenerator.class).in(Scopes.SINGLETON);
        this.bind(BlobStoreDeletedMessageVault.class).in(Scopes.SINGLETON);
        this.bind(DeletedMessageVault.class).to(BlobStoreDeletedMessageVault.class);
        Multibinder.newSetBinder((Binder)this.binder(), DeleteMessageListener.DeletionCallback.class).addBinding().to(DistributedDeletedMessageVaultDeletionCallback.class);
        this.bind(DistributedDeletedMessageVaultDeletionCallback.class).in(Scopes.SINGLETON);
        Multibinder reconnectionHandlerMultibinder = Multibinder.newSetBinder((Binder)this.binder(), SimpleConnectionPool.ReconnectionHandler.class);
        reconnectionHandlerMultibinder.addBinding().to(DeletedMessageVaultWorkQueueReconnectionHandler.class);
    }

    @ProvidesIntoSet
    InitializationOperation init(DistributedDeletedMessageVaultDeletionCallback callback) {
        return InitilizationOperationBuilder.forClass(DistributedDeletedMessageVaultDeletionCallback.class).init(callback::init);
    }
}

