/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.postgres.extensions.converters;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jooq.exception.DataTypeException;
import org.jooq.impl.AbstractConverter;
import org.jooq.postgres.extensions.types.AbstractInet;

abstract class AbstractInetConverter<U extends AbstractInet>
extends AbstractConverter<Object, U> {
    public AbstractInetConverter(Class<U> uType) {
        super(Object.class, uType);
    }

    abstract U construct(InetAddress var1, Integer var2);

    public U from(Object t) {
        if (t == null) {
            return null;
        }
        String[] s = t.toString().split("/");
        try {
            InetAddress a = InetAddress.getByName(s[0]);
            if (s.length == 1) {
                return this.construct(a, null);
            }
            return this.construct(a, Integer.valueOf(s[1]));
        }
        catch (UnknownHostException e) {
            throw new DataTypeException("Cannot parse InetAddress", (Throwable)e);
        }
    }

    public Object to(AbstractInet u) {
        return u == null ? null : (u.prefix() == null ? u.address().getHostAddress() : u.address().getHostAddress() + "/" + u.prefix());
    }
}

