/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.cloud;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.ssl.SslEngineFactory;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.InetSocketAddress;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class CloudConfig {
    private final InetSocketAddress proxyAddress;
    private final List<EndPoint> endPoints;
    private final String localDatacenter;
    private final SslEngineFactory sslEngineFactory;

    CloudConfig(@NonNull InetSocketAddress proxyAddress, @NonNull List<EndPoint> endPoints, @NonNull String localDatacenter, @NonNull SslEngineFactory sslEngineFactory) {
        this.proxyAddress = proxyAddress;
        this.endPoints = ImmutableList.copyOf(endPoints);
        this.localDatacenter = localDatacenter;
        this.sslEngineFactory = sslEngineFactory;
    }

    @NonNull
    public InetSocketAddress getProxyAddress() {
        return this.proxyAddress;
    }

    @NonNull
    public List<EndPoint> getEndPoints() {
        return this.endPoints;
    }

    @NonNull
    public String getLocalDatacenter() {
        return this.localDatacenter;
    }

    @NonNull
    public SslEngineFactory getSslEngineFactory() {
        return this.sslEngineFactory;
    }
}

