/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.change;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.jmap.api.change.CanNotCalculateChangesException;
import org.apache.james.jmap.api.change.Limit;
import org.apache.james.jmap.api.change.MailboxChange;
import org.apache.james.jmap.api.change.State;
import org.apache.james.mailbox.model.MailboxId;

public class MailboxChanges {
    private State newState;
    private final boolean hasMoreChanges;
    private final boolean isCountChangesOnly;
    private final Set<MailboxId> created;
    private final Set<MailboxId> updated;
    private final Set<MailboxId> destroyed;

    private MailboxChanges(State newState, boolean hasMoreChanges, boolean isCountChangesOnly, Set<MailboxId> created, Set<MailboxId> updated, Set<MailboxId> destroyed) {
        this.newState = newState;
        this.hasMoreChanges = hasMoreChanges;
        this.isCountChangesOnly = isCountChangesOnly;
        this.created = created;
        this.updated = updated;
        this.destroyed = destroyed;
    }

    public State getNewState() {
        return this.newState;
    }

    public boolean hasMoreChanges() {
        return this.hasMoreChanges;
    }

    public boolean isCountChangesOnly() {
        return this.isCountChangesOnly;
    }

    public Set<MailboxId> getCreated() {
        return this.created;
    }

    public Set<MailboxId> getUpdated() {
        return this.updated;
    }

    public Set<MailboxId> getDestroyed() {
        return this.destroyed;
    }

    public List<MailboxId> getAllChanges() {
        return ImmutableList.builder().addAll(this.created).addAll(this.updated).addAll(this.destroyed).build();
    }

    public static class MailboxChangesBuilder {
        private State state;
        private boolean hasMoreChanges;
        private boolean canAddMoreItem;
        private Limit limit;
        private boolean isCountChangeOnly;
        private Set<MailboxId> created;
        private Set<MailboxId> updated;
        private Set<MailboxId> destroyed;

        public MailboxChangesBuilder(State state, Limit limit) {
            this.limit = limit;
            this.state = state;
            this.hasMoreChanges = false;
            this.isCountChangeOnly = false;
            this.canAddMoreItem = true;
            this.created = new HashSet<MailboxId>();
            this.updated = new HashSet<MailboxId>();
            this.destroyed = new HashSet<MailboxId>();
        }

        public MailboxChangesBuilder add(MailboxChange change) {
            if (!this.canAddMoreItem) {
                return this;
            }
            HashSet<MailboxId> destroyedTemp = new HashSet<MailboxId>(this.destroyed);
            Sets.SetView createdTemp = Sets.difference((Set)ImmutableSet.builder().addAll(this.created).addAll(change.getCreated()).build(), (Set)ImmutableSet.copyOf(change.getDestroyed()));
            Sets.SetView updatedTemp = Sets.difference((Set)ImmutableSet.builder().addAll(this.updated).addAll((Iterable)Sets.difference((Set)ImmutableSet.copyOf(change.getUpdated()), (Set)createdTemp)).build(), (Set)ImmutableSet.copyOf(change.getDestroyed()));
            destroyedTemp.addAll((Collection<MailboxId>)Sets.difference((Set)ImmutableSet.copyOf(change.getDestroyed()), this.created));
            if (createdTemp.size() + updatedTemp.size() + destroyedTemp.size() > this.limit.getValue()) {
                this.hasMoreChanges = true;
                this.canAddMoreItem = false;
                return this;
            }
            this.isCountChangeOnly = this.calculateIsChangeOnly(change);
            this.state = change.getState();
            this.created = createdTemp;
            this.updated = updatedTemp;
            this.destroyed = destroyedTemp;
            return this;
        }

        public MailboxChanges build() {
            if (this.hasMoreChanges && this.created.isEmpty() && this.updated.isEmpty() && this.destroyed.isEmpty()) {
                throw new CanNotCalculateChangesException(String.format("Current change collector limit %d is exceeded by a single change, hence we cannot calculate changes.", this.limit.getValue()));
            }
            return new MailboxChanges(this.state, this.hasMoreChanges, this.isCountChangeOnly, this.created, this.updated, this.destroyed);
        }

        private boolean calculateIsChangeOnly(MailboxChange change) {
            if (this.created.isEmpty() && this.updated.isEmpty() && this.destroyed.isEmpty()) {
                return change.isCountChange();
            }
            return this.isCountChangeOnly && change.isCountChange();
        }

        public static class MailboxChangeCollector
        implements Collector<MailboxChange, MailboxChangesBuilder, MailboxChanges> {
            private final Limit limit;
            private final State state;

            public MailboxChangeCollector(State state, Limit limit) {
                this.limit = limit;
                this.state = state;
            }

            @Override
            public Supplier<MailboxChangesBuilder> supplier() {
                return () -> new MailboxChangesBuilder(this.state, this.limit);
            }

            @Override
            public BiConsumer<MailboxChangesBuilder, MailboxChange> accumulator() {
                return MailboxChangesBuilder::add;
            }

            @Override
            public BinaryOperator<MailboxChangesBuilder> combiner() {
                throw new NotImplementedException("Not supported");
            }

            @Override
            public Function<MailboxChangesBuilder, MailboxChanges> finisher() {
                return MailboxChangesBuilder::build;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return ImmutableSet.of();
            }
        }
    }
}

