/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.SerializableQuotaLimitValue;
import org.apache.james.mailbox.model.SerializableQuotaUsageValue;

public class SerializableQuota<T extends QuotaLimitValue<T>, U extends QuotaUsageValue<U, T>>
implements Serializable {
    public static final long UNLIMITED = -1L;
    private final SerializableQuotaLimitValue<T> max;
    private final SerializableQuotaUsageValue<T, U> used;

    public static <T extends QuotaLimitValue<T>, U extends QuotaUsageValue<U, T>> SerializableQuota<T, U> newInstance(Quota<T, U> quota) {
        return SerializableQuota.newInstance(quota.getUsed(), quota.getLimit());
    }

    public static <T extends QuotaLimitValue<T>, U extends QuotaUsageValue<U, T>> SerializableQuota<T, U> newInstance(U used, T max) {
        return new SerializableQuota(new SerializableQuotaUsageValue(used), new SerializableQuotaLimitValue<T>(max));
    }

    private SerializableQuota(SerializableQuotaUsageValue<T, U> used, SerializableQuotaLimitValue<T> max) {
        this.max = max;
        this.used = used;
    }

    public Long encodeAsLong() {
        return this.max.encodeAsLong();
    }

    public Long getUsed() {
        return Optional.ofNullable(this.used).map(SerializableQuotaUsageValue::encodeAsLong).orElse(null);
    }

    public boolean equals(Object o) {
        if (o instanceof SerializableQuota) {
            SerializableQuota that = (SerializableQuota)o;
            return Objects.equals(this.max, that.max) && Objects.equals(this.used, that.used);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.max, this.used);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("max", this.max).add("used", this.used).toString();
    }
}

