/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.security.GeneralSecurityException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.utils.base64;
import org.xbill.DNS.utils.hexdump;

public class TSIG {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TSIG.class);
    public static final Name GSS_TSIG = Name.fromConstantString("gss-tsig.");
    public static final Name HMAC_MD5;
    @Deprecated
    public static final Name HMAC;
    public static final Name HMAC_SHA1;
    public static final Name HMAC_SHA224;
    public static final Name HMAC_SHA256;
    public static final Name HMAC_SHA384;
    public static final Name HMAC_SHA512;
    private static final Map<Name, String> algMap;
    public static final Duration FUDGE;
    private final Name alg;
    private final Clock clock;
    private final Name name;
    private final SecretKey macKey;
    private final String macAlgorithm;
    private final Mac sharedHmac;

    public static Name algorithmToName(String alg) {
        for (Map.Entry<Name, String> entry : algMap.entrySet()) {
            if (!alg.equalsIgnoreCase(entry.getValue())) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Unknown algorithm: " + alg);
    }

    public static String nameToAlgorithm(Name name) {
        String alg = algMap.get(name);
        if (alg != null) {
            return alg;
        }
        throw new IllegalArgumentException("Unknown algorithm: " + name);
    }

    private static boolean verify(byte[] expected, byte[] signature) {
        if (signature.length < expected.length) {
            byte[] truncated = new byte[signature.length];
            System.arraycopy(expected, 0, truncated, 0, truncated.length);
            expected = truncated;
        }
        return Arrays.equals(signature, expected);
    }

    private Mac initHmac() {
        if (this.sharedHmac != null) {
            try {
                return (Mac)this.sharedHmac.clone();
            }
            catch (CloneNotSupportedException e) {
                this.sharedHmac.reset();
                return this.sharedHmac;
            }
        }
        try {
            Mac mac = Mac.getInstance(this.macAlgorithm);
            mac.init(this.macKey);
            return mac;
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalArgumentException("Caught security exception setting up HMAC.", ex);
        }
    }

    public TSIG(Name algorithm, Name name, String key) {
        this(algorithm, name, Objects.requireNonNull(base64.fromString(key)));
    }

    public TSIG(Name algorithm, Name name, byte[] keyBytes) {
        this(algorithm, name, new SecretKeySpec(keyBytes, TSIG.nameToAlgorithm(algorithm)));
    }

    public TSIG(Name algorithm, Name name, SecretKey key) {
        this(algorithm, name, key, Clock.systemUTC());
    }

    public TSIG(Name algorithm, Name name, SecretKey key, Clock clock) {
        this.name = name;
        this.alg = algorithm;
        this.clock = clock;
        this.macAlgorithm = TSIG.nameToAlgorithm(algorithm);
        this.macKey = key;
        this.sharedHmac = null;
    }

    @Deprecated
    public TSIG(Mac mac, Name name) {
        this.name = name;
        this.sharedHmac = mac;
        this.macAlgorithm = null;
        this.macKey = null;
        this.clock = Clock.systemUTC();
        this.alg = TSIG.algorithmToName(mac.getAlgorithm());
    }

    @Deprecated
    public TSIG(Name name, byte[] key) {
        this(HMAC_MD5, name, key);
    }

    public TSIG(Name algorithm, String name, String key) {
        byte[] keyBytes = base64.fromString(key);
        if (keyBytes == null) {
            throw new IllegalArgumentException("Invalid TSIG key string");
        }
        try {
            this.name = Name.fromString(name, Name.root);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException("Invalid TSIG key name");
        }
        this.alg = algorithm;
        this.clock = Clock.systemUTC();
        this.macAlgorithm = TSIG.nameToAlgorithm(algorithm);
        this.sharedHmac = null;
        this.macKey = new SecretKeySpec(keyBytes, this.macAlgorithm);
    }

    public TSIG(String algorithm, String name, String key) {
        this(TSIG.algorithmToName(algorithm), name, key);
    }

    @Deprecated
    public TSIG(String name, String key) {
        this(HMAC_MD5, name, key);
    }

    @Deprecated
    public static TSIG fromString(String str) {
        String[] parts = str.split("[:/]", 3);
        switch (parts.length) {
            case 2: {
                return new TSIG(HMAC_MD5, parts[0], parts[1]);
            }
            case 3: {
                return new TSIG(parts[0], parts[1], parts[2]);
            }
        }
        throw new IllegalArgumentException("Invalid TSIG key specification");
    }

    public TSIGRecord generate(Message m, byte[] b, int error, TSIGRecord old) {
        return this.generate(m, b, error, old, true);
    }

    public TSIGRecord generate(Message m, byte[] b, int error, TSIGRecord old, boolean fullSignature) {
        byte[] signature;
        int fudgeOption;
        Instant timeSigned = error == 18 ? old.getTimeSigned() : this.clock.instant();
        boolean signing = false;
        Mac hmac = null;
        if (error == 0 || error == 18 || error == 22) {
            signing = true;
            hmac = this.initHmac();
        }
        Duration fudge = (fudgeOption = Options.intValue("tsigfudge")) < 0 || fudgeOption > Short.MAX_VALUE ? FUDGE : Duration.ofSeconds(fudgeOption);
        if (old != null && signing) {
            TSIG.hmacAddSignature(hmac, old);
        }
        if (signing) {
            if (log.isTraceEnabled()) {
                log.trace(hexdump.dump("TSIG-HMAC rendered message", b));
            }
            hmac.update(b);
        }
        DNSOutput out = new DNSOutput();
        if (fullSignature) {
            this.name.toWireCanonical(out);
            out.writeU16(255);
            out.writeU32(0L);
            this.alg.toWireCanonical(out);
        }
        TSIG.writeTsigTimersVariables(timeSigned, fudge, out);
        if (fullSignature) {
            out.writeU16(error);
            out.writeU16(0);
        }
        if (signing) {
            byte[] tsigVariables = out.toByteArray();
            if (log.isTraceEnabled()) {
                log.trace(hexdump.dump("TSIG-HMAC variables", tsigVariables));
            }
            signature = hmac.doFinal(tsigVariables);
        } else {
            signature = new byte[]{};
        }
        byte[] other = null;
        if (error == 18) {
            out = new DNSOutput(6);
            TSIG.writeTsigTime(this.clock.instant(), out);
            other = out.toByteArray();
        }
        return new TSIGRecord(this.name, 255, 0L, this.alg, timeSigned, fudge, signature, m.getHeader().getID(), error, other);
    }

    public void apply(Message m, TSIGRecord old) {
        this.apply(m, 0, old, true);
    }

    public void apply(Message m, int error, TSIGRecord old) {
        this.apply(m, error, old, true);
    }

    public void apply(Message m, TSIGRecord old, boolean fullSignature) {
        this.apply(m, 0, old, fullSignature);
    }

    public void apply(Message m, int error, TSIGRecord old, boolean fullSignature) {
        TSIGRecord r = this.generate(m, m.toWire(), error, old, fullSignature);
        m.addRecord(r, 3);
        m.tsigState = 3;
    }

    @Deprecated
    public void applyStream(Message m, TSIGRecord old, boolean fullSignature) {
        this.apply(m, 0, old, fullSignature);
    }

    @Deprecated
    public byte verify(Message m, byte[] b, int length, TSIGRecord old) {
        return (byte)this.verify(m, b, old);
    }

    public int verify(Message m, byte[] b, TSIGRecord old) {
        return this.verify(m, b, old, true);
    }

    public int verify(Message m, byte[] b, TSIGRecord old, boolean fullSignature) {
        m.tsigState = 4;
        TSIGRecord tsig = m.getTSIG();
        if (tsig == null) {
            return 1;
        }
        if (!tsig.getName().equals(this.name) || !tsig.getAlgorithm().equals(this.alg)) {
            log.debug("BADKEY failure, expected: {}/{}, actual: {}/{}", new Object[]{this.name, this.alg, tsig.getName(), tsig.getAlgorithm()});
            return 17;
        }
        Mac hmac = this.initHmac();
        if (old != null && tsig.getError() != 17 && tsig.getError() != 16) {
            TSIG.hmacAddSignature(hmac, old);
        }
        m.getHeader().decCount(3);
        byte[] header = m.getHeader().toWire();
        m.getHeader().incCount(3);
        if (log.isTraceEnabled()) {
            log.trace(hexdump.dump("TSIG-HMAC header", header));
        }
        hmac.update(header);
        int len = m.tsigstart - header.length;
        if (log.isTraceEnabled()) {
            log.trace(hexdump.dump("TSIG-HMAC message after header", b, header.length, len));
        }
        hmac.update(b, header.length, len);
        DNSOutput out = new DNSOutput();
        if (fullSignature) {
            tsig.getName().toWireCanonical(out);
            out.writeU16(tsig.dclass);
            out.writeU32(tsig.ttl);
            tsig.getAlgorithm().toWireCanonical(out);
        }
        TSIG.writeTsigTimersVariables(tsig.getTimeSigned(), tsig.getFudge(), out);
        if (fullSignature) {
            out.writeU16(tsig.getError());
            if (tsig.getOther() != null) {
                out.writeU16(tsig.getOther().length);
                out.writeByteArray(tsig.getOther());
            } else {
                out.writeU16(0);
            }
        }
        byte[] tsigVariables = out.toByteArray();
        if (log.isTraceEnabled()) {
            log.trace(hexdump.dump("TSIG-HMAC variables", tsigVariables));
        }
        hmac.update(tsigVariables);
        byte[] signature = tsig.getSignature();
        int digestLength = hmac.getMacLength();
        int minDigestLength = Math.max(10, digestLength / 2);
        if (signature.length > digestLength) {
            log.debug("BADSIG: signature too long, expected: {}, actual: {}", (Object)digestLength, (Object)signature.length);
            return 16;
        }
        if (signature.length < minDigestLength) {
            log.debug("BADSIG: signature too short, expected: {} of {}, actual: {}", new Object[]{minDigestLength, digestLength, signature.length});
            return 16;
        }
        byte[] expectedSignature = hmac.doFinal();
        if (!TSIG.verify(expectedSignature, signature)) {
            if (log.isDebugEnabled()) {
                log.debug("BADSIG: signature verification failed, expected: {}, actual: {}", (Object)base64.toString(expectedSignature), (Object)base64.toString(signature));
            }
            return 16;
        }
        Instant now = this.clock.instant();
        Duration delta = Duration.between(now, tsig.getTimeSigned()).abs();
        if (delta.compareTo(tsig.getFudge()) > 0) {
            log.debug("BADTIME failure, now {} +/- tsig {} > fudge {}", new Object[]{now, tsig.getTimeSigned(), tsig.getFudge()});
            return 18;
        }
        m.tsigState = 1;
        return 0;
    }

    public int recordLength() {
        return this.name.length() + 10 + this.alg.length() + 8 + 18 + 4 + 8;
    }

    private static void hmacAddSignature(Mac hmac, TSIGRecord tsig) {
        byte[] signatureSize = DNSOutput.toU16(tsig.getSignature().length);
        if (log.isTraceEnabled()) {
            log.trace(hexdump.dump("TSIG-HMAC signature size", signatureSize));
            log.trace(hexdump.dump("TSIG-HMAC signature", tsig.getSignature()));
        }
        hmac.update(signatureSize);
        hmac.update(tsig.getSignature());
    }

    private static void writeTsigTimersVariables(Instant instant, Duration fudge, DNSOutput out) {
        TSIG.writeTsigTime(instant, out);
        out.writeU16((int)fudge.getSeconds());
    }

    private static void writeTsigTime(Instant instant, DNSOutput out) {
        long time = instant.getEpochSecond();
        int timeHigh = (int)(time >> 32);
        long timeLow = time & 0xFFFFFFFFL;
        out.writeU16(timeHigh);
        out.writeU32(timeLow);
    }

    static {
        HMAC = HMAC_MD5 = Name.fromConstantString("HMAC-MD5.SIG-ALG.REG.INT.");
        HMAC_SHA1 = Name.fromConstantString("hmac-sha1.");
        HMAC_SHA224 = Name.fromConstantString("hmac-sha224.");
        HMAC_SHA256 = Name.fromConstantString("hmac-sha256.");
        HMAC_SHA384 = Name.fromConstantString("hmac-sha384.");
        HMAC_SHA512 = Name.fromConstantString("hmac-sha512.");
        HashMap<Name, String> out = new HashMap<Name, String>();
        out.put(HMAC_MD5, "HmacMD5");
        out.put(HMAC_SHA1, "HmacSHA1");
        out.put(HMAC_SHA224, "HmacSHA224");
        out.put(HMAC_SHA256, "HmacSHA256");
        out.put(HMAC_SHA384, "HmacSHA384");
        out.put(HMAC_SHA512, "HmacSHA512");
        algMap = Collections.unmodifiableMap(out);
        FUDGE = Duration.ofSeconds(300L);
    }

    public static class StreamVerifier {
        private final TSIG key;
        private int nresponses;
        private int lastsigned;
        private TSIGRecord lastTSIG;

        public StreamVerifier(TSIG tsig, TSIGRecord queryTsig) {
            this.key = tsig;
            this.nresponses = 0;
            this.lastTSIG = queryTsig;
        }

        public int verify(Message m, byte[] b) {
            boolean required;
            TSIGRecord tsig = m.getTSIG();
            ++this.nresponses;
            if (this.nresponses == 1) {
                int result = this.key.verify(m, b, this.lastTSIG);
                this.lastTSIG = tsig;
                return result;
            }
            if (tsig != null) {
                int result = this.key.verify(m, b, this.lastTSIG, false);
                this.lastsigned = this.nresponses;
                this.lastTSIG = tsig;
                return result;
            }
            boolean bl = required = this.nresponses - this.lastsigned >= 100;
            if (required) {
                log.debug("FORMERR: missing required signature on {}th message", (Object)this.nresponses);
                m.tsigState = 4;
                return 1;
            }
            log.trace("Intermediate message {} without signature", (Object)this.nresponses);
            m.tsigState = 2;
            return 0;
        }
    }
}

