/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.MailHook;

public abstract class ValidSenderDomainHandler
implements MailHook {
    @Override
    public HookResult doMail(SMTPSession session, MaybeSender sender) {
        if (!sender.isNullSender() && !this.hasMXRecord(session, sender.get().getDomain().name())) {
            return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("501").smtpDescription(DSNStatus.getStatus(5, "1.7") + " sender " + sender + " contains a domain with no valid MX records").build();
        }
        return HookResult.DECLINED;
    }

    protected abstract boolean hasMXRecord(SMTPSession var1, String var2);
}

