/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.driver;

import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.execution.driver.DataDriverContext;
import org.apache.iotdb.db.queryengine.execution.driver.Driver;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.source.DataSourceOperator;
import org.apache.iotdb.db.storageengine.dataregion.VirtualDataRegion;
import org.apache.iotdb.db.storageengine.dataregion.read.IQueryDataSource;

@NotThreadSafe
public class DataDriver
extends Driver {
    private boolean init = false;
    private final long estimatedMemorySize;

    public DataDriver(Operator root, DriverContext driverContext, long estimatedMemorySize) {
        super(root, driverContext);
        this.estimatedMemorySize = estimatedMemorySize;
    }

    @Override
    protected boolean init(SettableFuture<?> blockedFuture) {
        if (!this.init) {
            try {
                if (!this.initialize()) {
                    blockedFuture.set(null);
                    return false;
                }
                return true;
            }
            catch (Throwable t) {
                LOGGER.error("Failed to do the initialization for driver {} ", (Object)this.driverContext.getDriverTaskID(), (Object)t);
                this.driverContext.failed(t);
                blockedFuture.setException(t);
                return false;
            }
        }
        return true;
    }

    private boolean initialize() throws QueryProcessException {
        try {
            List<DataSourceOperator> sourceOperators = ((DataDriverContext)this.driverContext).getSourceOperators();
            if (sourceOperators != null && !sourceOperators.isEmpty()) {
                IQueryDataSource dataSource = this.initQueryDataSource();
                if (dataSource == null) {
                    throw new IllegalStateException("QueryDataSource should never be null!");
                }
                if (dataSource == VirtualDataRegion.UNFINISHED_QUERY_DATA_SOURCE) {
                } else {
                    sourceOperators.forEach(sourceOperator -> sourceOperator.initQueryDataSource(dataSource.clone()));
                    this.init = true;
                }
            } else {
                this.init = true;
            }
        }
        finally {
            if (this.init) {
                ((DataDriverContext)this.driverContext).clearSourceOperators();
                QUERY_EXECUTION_METRICS.recordExecutionCost("query_resource_init", this.driverContext.getFragmentInstanceContext().getInitQueryDataSourceCost());
            }
        }
        return this.init;
    }

    @Override
    protected void releaseResource() {
        this.driverContext.getFragmentInstanceContext().decrementNumOfUnClosedDriver();
    }

    private IQueryDataSource initQueryDataSource() throws QueryProcessException {
        return ((DataDriverContext)this.driverContext).getSharedQueryDataSource();
    }

    @Override
    public long getEstimatedMemorySize() {
        return this.estimatedMemorySize;
    }
}

