/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.entity;

import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.commons.auth.entity.PrivilegeModelType;

public enum PrivilegeType {
    READ_DATA(PrivilegeModelType.TREE),
    WRITE_DATA(PrivilegeModelType.TREE),
    READ_SCHEMA(PrivilegeModelType.TREE),
    WRITE_SCHEMA(PrivilegeModelType.TREE),
    MANAGE_USER(PrivilegeModelType.SYSTEM),
    MANAGE_ROLE(PrivilegeModelType.SYSTEM),
    USE_TRIGGER(PrivilegeModelType.SYSTEM),
    USE_UDF(PrivilegeModelType.SYSTEM),
    USE_CQ(PrivilegeModelType.SYSTEM),
    USE_PIPE(PrivilegeModelType.SYSTEM),
    USE_MODEL(PrivilegeModelType.SYSTEM),
    EXTEND_TEMPLATE(PrivilegeModelType.SYSTEM),
    MANAGE_DATABASE(PrivilegeModelType.SYSTEM),
    MAINTAIN(PrivilegeModelType.SYSTEM),
    CREATE(PrivilegeModelType.RELATIONAL),
    DROP(PrivilegeModelType.RELATIONAL),
    ALTER(PrivilegeModelType.RELATIONAL),
    SELECT(PrivilegeModelType.RELATIONAL),
    INSERT(PrivilegeModelType.RELATIONAL),
    DELETE(PrivilegeModelType.RELATIONAL);

    private final PrivilegeModelType modelType;

    private PrivilegeType(PrivilegeModelType modelType) {
        this.modelType = modelType;
    }

    public boolean isPathPrivilege() {
        return this.modelType == PrivilegeModelType.TREE;
    }

    public boolean isSystemPrivilege() {
        return this.modelType == PrivilegeModelType.SYSTEM;
    }

    public boolean isRelationalPrivilege() {
        return this.modelType == PrivilegeModelType.RELATIONAL;
    }

    public static int getPrivilegeCount(PrivilegeModelType type) {
        int size = 0;
        block5: for (PrivilegeType item : PrivilegeType.values()) {
            switch (type) {
                case TREE: {
                    size += item.isPathPrivilege() ? 1 : 0;
                    continue block5;
                }
                case SYSTEM: {
                    size += item.isSystemPrivilege() ? 1 : 0;
                    continue block5;
                }
                case RELATIONAL: {
                    size += item.isRelationalPrivilege() ? 1 : 0;
                    continue block5;
                }
            }
        }
        return size;
    }

    public static Set<PrivilegeType> toPriType(Set<Integer> priSet) {
        HashSet<PrivilegeType> typeSet = new HashSet<PrivilegeType>();
        for (Integer pri : priSet) {
            typeSet.add(PrivilegeType.values()[pri]);
        }
        return typeSet;
    }

    public boolean forRelationalSys() {
        return this == MANAGE_USER || this == MANAGE_ROLE;
    }

    public PrivilegeModelType getModelType() {
        return this.modelType;
    }
}

