/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.tsfile;

import java.util.Objects;
import org.apache.tsfile.utils.FilePathUtils;

public class TsFileID {
    public final int regionId;
    public final long timePartitionId;
    public final long timestamp;
    public final long fileVersion;
    public final long compactionVersion;

    public TsFileID() {
        this.regionId = -1;
        this.timePartitionId = -1L;
        this.timestamp = -1L;
        this.fileVersion = -1L;
        this.compactionVersion = -1L;
    }

    public TsFileID(int regionId, long timePartitionId, long timestamp, long fileVersion, long compactionVersion) {
        this.regionId = regionId;
        this.timePartitionId = timePartitionId;
        this.timestamp = timestamp;
        this.fileVersion = fileVersion;
        this.compactionVersion = compactionVersion;
    }

    public TsFileID(String tsFileAbsolutePath) {
        int tmpRegionId = -1;
        long tmpTimePartitionId = -1L;
        String[] pathSegments = FilePathUtils.splitTsFilePath((String)tsFileAbsolutePath);
        int pathLength = pathSegments.length;
        if (pathLength >= 3) {
            try {
                tmpRegionId = Integer.parseInt(pathSegments[pathLength - 3]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                tmpTimePartitionId = Long.parseLong(pathSegments[pathLength - 2]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.regionId = tmpRegionId;
        this.timePartitionId = tmpTimePartitionId;
        long[] arr = null;
        try {
            arr = TsFileID.splitAndGetVersionArray(pathSegments[pathLength - 1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.timestamp = arr == null || arr.length != 3 ? -1L : arr[0];
        this.fileVersion = arr == null || arr.length != 3 ? -1L : arr[1];
        this.compactionVersion = arr == null || arr.length != 3 ? -1L : arr[2];
    }

    private static long[] splitAndGetVersionArray(String tsFileName) {
        String[] names = tsFileName.split("-");
        long[] versionArray = new long[3];
        if (names.length != 4) {
            return versionArray;
        }
        versionArray[0] = Long.parseLong(names[0]);
        versionArray[1] = Long.parseLong(names[1]);
        int dotIndex = names[3].indexOf(".");
        versionArray[2] = Long.parseLong(names[2]) << 32 | Long.parseLong(names[3].substring(0, dotIndex));
        return versionArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsFileID that = (TsFileID)o;
        return this.regionId == that.regionId && this.timePartitionId == that.timePartitionId && this.timestamp == that.timestamp && this.fileVersion == that.fileVersion && this.compactionVersion == that.compactionVersion;
    }

    public int hashCode() {
        return Objects.hash(this.regionId, this.timePartitionId, this.timestamp, this.fileVersion, this.compactionVersion);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getInnerCompactionCount() {
        return this.compactionVersion >>> 32;
    }

    public long getCrossCompactionCount() {
        return this.compactionVersion & 0xFFFFFFFFL;
    }
}

