/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.payload.thrift.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.IoTDBConnectorRequestVersion;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class PipeTransferHandshakeV2Req
extends TPipeTransferReq {
    private transient Map<String, String> params;

    public Map<String, String> getParams() {
        return this.params;
    }

    protected abstract PipeRequestType getPlanType();

    protected final PipeTransferHandshakeV2Req convertToTPipeTransferReq(Map<String, String> params) throws IOException {
        this.version = IoTDBConnectorRequestVersion.VERSION_1.getVersion();
        this.type = this.getPlanType().getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((int)params.size(), (OutputStream)outputStream);
            for (Map.Entry<String, String> entry : params.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((String)entry.getValue(), (OutputStream)outputStream);
            }
            this.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        this.params = params;
        return this;
    }

    protected final PipeTransferHandshakeV2Req translateFromTPipeTransferReq(TPipeTransferReq transferReq) {
        HashMap<String, String> params = new HashMap<String, String>();
        int size = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
        for (int i = 0; i < size; ++i) {
            String key = ReadWriteIOUtils.readString((ByteBuffer)transferReq.body);
            String value = ReadWriteIOUtils.readString((ByteBuffer)transferReq.body);
            params.put(key, value);
        }
        this.params = params;
        this.version = transferReq.version;
        this.type = transferReq.type;
        this.body = transferReq.body;
        return this;
    }

    public final byte[] convertToTransferHandshakeBytes(Map<String, String> params) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            Object object;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                ReadWriteIOUtils.write((byte)IoTDBConnectorRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((short)this.getPlanType().getType(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((int)params.size(), (OutputStream)outputStream);
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                    ReadWriteIOUtils.write((String)entry.getValue(), (OutputStream)outputStream);
                }
                object = byteArrayOutputStream.toByteArray();
            }
            return object;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferHandshakeV2Req that = (PipeTransferHandshakeV2Req)((Object)obj);
        return Objects.equals(this.params, that.params) && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.params, this.version, this.type, this.body);
    }
}

